////////////////////////////////////////////////////////////////////////////////////
/////    Map Shader for maps, Extension of ItemShader                          /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifndef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform vec3 g_CameraDirection;

uniform sampler2D m_BasicTexture;
uniform sampler2D m_WorldTexture;
uniform vec2 m_PlayerLocation;

varying vec3 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec4 texCoord;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    vec4 fragColor = texture2D(m_BasicTexture, texCoord.xy);

    if(fragColor.a < 0.5){
        discard;
    }
    
    vec3 worldColor = texture2D(m_WorldTexture, texCoord.xy).rgb;
    fragColor.rgb = mix(fragColor.rgb, worldColor.rgb, 0.6);

    fragColor.rgb = mix(fragColor.rgb, vec3(0.0), smoothstep(0.0, 7.5, position.y));
    
    //If normal-quality light is enabled: Per-Pixel-Lighting calculation (dynamic Spotlights)
    #ifndef VERTEXLIGHTING
        fragColor.rgb *= calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #else
        fragColor.rgb *= light;
    #endif

    float distToPlayer = distance(texCoord.xy, m_PlayerLocation);
    
    #ifdef FOG
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, fog.w);
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}