////////////////////////////////////////////////////////////////////////////////////
/////    Unshaded Shader for unlit Objects                                     /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef TEXTUREARRAY
    #extension GL_EXT_gpu_shader4 : enable
    #extension GL_EXT_texture_array : enable

    uniform sampler2DArray m_Textures_Array;
    varying vec3 texCoord;
#else
    uniform sampler2D m_Texture;
    varying vec2 texCoord;
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

#ifdef MASKTEXTURE
    uniform sampler2D m_MaskTexture;
#endif

#ifdef DISCARD
    uniform float m_AlphaDiscardThreshold;
#endif

uniform vec4 m_Color;

uniform float m_Opacity;

varying vec3 position;
varying vec3 worldpos;
varying vec3 color;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef MASKTEXTURE
        vec4 mask = texture2D(m_MaskTexture, texCoord);
        if(mask.a < 0.1){
            discard;
        }
    #endif

    #ifdef TEXTUREARRAY
        vec4 fragColor = texture2DArray(m_Textures_Array, texCoord);
        #ifdef COLOR
            #ifdef MULTCOLOR
                fragColor *= m_Color;
            #else
                fragColor.rgb = mix(fragColor.rgb, m_Color.rgb, m_Color.a);
            #endif
        #endif
    #else
        #ifdef TEXTURE
            vec4 fragColor = texture2D(m_Texture, texCoord);
            #ifdef COLOR
                #ifdef MULTCOLOR
                    fragColor *= m_Color;
                #else
                    fragColor.rgb = mix(fragColor.rgb, m_Color.rgb, m_Color.a);
                #endif
            #endif
        #else
            #ifdef COLOR
                vec4 fragColor = m_Color;
            #else
                vec4 fragColor = vec4(1.0);
            #endif
        #endif
    #endif

    #ifdef DISCARD
        if(fragColor.a < m_AlphaDiscardThreshold){
            discard;
        }
    #endif
    
    //Opacity
    fragColor.a *= m_Opacity;
    
    #ifdef FOG
        fragColor.xyz = mix(fog.xyz, fragColor.xyz, fog.w);
    #endif

    #ifdef VERTEXCOLOR
        fragColor.xyz += color;
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}