////////////////////////////////////////////////////////////////////////////////////
/////    Shader for BitmapFonts                                                /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;

attribute vec3 inPosition;
attribute vec4 inColor;
attribute vec2 inTexCoord;

varying vec3 position;
varying vec3 worldpos;
varying vec2 texCoord;
varying vec4 color;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    position = inPosition;
    worldpos = vec3(g_WorldMatrix * pos);
    texCoord = inTexCoord;
    
    #ifdef VERTEXCOLOR
        color = inColor;
    #endif
}