////////////////////////////////////////////////////////////////////////////////////
/////    Shader for BitmapFonts                                                /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform sampler2D m_ColorMap;
varying vec2 texCoord;

uniform float m_AlphaDiscardThreshold;

uniform vec4 m_Color;

uniform float m_Opacity;

varying vec3 position;
varying vec3 worldpos;
varying vec4 color;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef COLORMAP
        vec4 fragColor = texture2D(m_ColorMap, texCoord);
        #ifdef COLOR
            #ifdef MULTCOLOR
                fragColor *= m_Color;
            #else
                fragColor.rgb = mix(fragColor.rgb, m_Color.rgb, m_Color.a);
            #endif
        #endif
    #else
        #ifdef COLOR
            vec4 fragColor = m_Color;
        #else
            vec4 fragColor = vec4(1.0);
        #endif
    #endif

    if(fragColor.a < m_AlphaDiscardThreshold){
        discard;
    }
    
    //Opacity
    fragColor.a *= m_Opacity;
    
    #ifdef VERTEXCOLOR
        fragColor *= color;
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}