////////////////////////////////////////////////////////////////////////////////////
/////    AnimatedSprite Shader for image-based 2D-Animations                   /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;
uniform float g_Time;

uniform vec2 m_NumTiles;  //X=Num Horizontal Tiles, Y=Num Vertical Tiles
uniform float m_Speed;

attribute vec3 inPosition;
attribute vec2 inTexCoord;

varying vec2 texCoord;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;
    
    vec2 anim = vec2(inTexCoord);
    
    float row = floor(mod(floor(g_Time * m_Speed), (m_NumTiles.x * m_NumTiles.y)) / m_NumTiles.y);
    anim.x = (anim.x / m_NumTiles.x) + (mod(floor(g_Time * m_Properties), m_NumTiles.x) / m_NumTiles.x);
    anim.y = (anim.y / m_NumTiles.y) + (((m_NumTiles.y - 1.0) - row) / m_NumTiles.y);

    //float speed = 30.0;
    //float row = floor(mod(floor(g_Time * speed), 49.0) / 7.0);
    //anim.x = (anim.x / 7.0) + (mod(floor(g_Time * speed), 7.0) / 7.0);
    //anim.y = (anim.y / 7.0) + ((6.0 - row) / 7.0);

    texCoord = anim;
}