/****************************
	T e s t  -  A Rising World Java plug-in to test RWGui.

	SampleDlgBox.java - A sample use of the GuiDialogueBox class

	Created by : Maurizio M. Gavioli 2016-12-18

	(C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
	Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)

*****************************/

package com.vistamaresoft.sampledlgbox;

import com.vistamaresoft.rwgui.GuiDialogueBox;
import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.RWGui;
import com.vistamaresoft.rwgui.RWGui.RWGuiCallback;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;

public class MyDlgBox extends GuiDialogueBox
{

	public MyDlgBox(Player player)
	{
		// Create a dialogue box with a global vertical arrangement
		super(SampleDlgBox.plugin, "RW Gui test", RWGui.LAYOUT_VERT, null);
		setCallback(new DlgHandler());
		// add two label to it: they will be laid out one below the other, as the global arrangement is vertical;
		// as they have an id, they will respond to click events
		addChild(new GuiLabel("Action 1", 0, 0, false), 1, null);
		addChild(new GuiLabel("Action 2", 0, 0, false), 2, null);
		// add a new horizontal layout as a child of the dialogue box;
		// it will be arranged below the the labels, but its own children will arranged horizontally
		GuiLayout	hLayout	= addNewLayoutChild(RWGui.LAYOUT_HORIZ, RWGui.LAYOUT_H_LEFT | RWGui.LAYOUT_V_TOP);
		// add two vertical layouts nested within the horizontal layout: they will arranged side by side
		// (as they belong to a horizontal layout) and their own children will be arranged vertically
		// the first vertical layout has its children aligned on the right side
		GuiLayout vLayout1	= hLayout.addNewLayoutChild(RWGui.LAYOUT_VERT, RWGui.LAYOUT_H_RIGHT | RWGui.LAYOUT_V_TOP);
		// the second vertical layout has its children aligned on the left side
		// it has less children than the first and they will spread across the available vertical space
		GuiLayout vLayout2	= hLayout.addNewLayoutChild(RWGui.LAYOUT_VERT, RWGui.LAYOUT_H_LEFT | RWGui.LAYOUT_V_SPREAD);
		// add some labels as children of the vertical layouts
		vLayout1.addChild(new GuiLabel("Item 1 1", 0, 0, false), 3);
		vLayout1.addChild(new GuiLabel("Item 1 2 with longer text", 0, 0, false), 4);
		vLayout1.addChild(new GuiLabel("Item 1 3", 0, 0, false), 5);
		vLayout2.addChild(new GuiLabel("Item 2 1", 0, 0, false), 6);
		vLayout2.addChild(new GuiLabel("Item 2 2", 0, 0, false), 7);
		// more labels below the horizontal layout
		addChild(new GuiLabel("Action 3", 0, 0, false), 8, null);
		addChild(new GuiLabel("Another action", 0, 0, false), 9, null);
		// finally, show the dialogue box to the player
		show(player);
	}

	private class DlgHandler implements RWGuiCallback
	{
		@Override
		public void onCall(Player player, int id, Object data)
		{
			switch (id)
			{
			// some clickable item pressed: provide a minimal feedback
			case 1:
				player.sendTextMessage("Action 1 clicked");
				break;
			case 2:			// create new area
				player.sendTextMessage("Action 2 clicked");
				break;
			case 3:
				player.sendTextMessage("Item 1 1 clicked");
				break;
			case 4:
				player.sendTextMessage("Item 1 2 clicked");
				break;
			case 5:
				player.sendTextMessage("Item 1 3 clicked");
				break;
			case 6:
				player.sendTextMessage("Item 2 1 clicked");
				break;
			case 7:
				player.sendTextMessage("Item 2 2 clicked");
				break;
			case 8:
				player.sendTextMessage("Action 3 clicked");
				break;
			case 9:
				player.sendTextMessage("Last action clicked");
				break;
			}
		}
	}

}
