/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.bank;

import com.vistamaresoft.bank.Bank;
import com.vistamaresoft.bank.Db;
import com.vistamaresoft.bank.Msgs;
import com.vistamaresoft.rwgui.GuiDialogueBox;
import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.GuiMessageBox;
import com.vistamaresoft.rwgui.GuiModalWindow;
import com.vistamaresoft.rwgui.GuiUsersMenu;
import com.vistamaresoft.rwgui.RWGui;
import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.objects.Player;

public class GuiTransfer
extends GuiDialogueBox {
    private static final int DESCR_WIDTH = 150;
    private static final int TOTXT_W = 132;
    private static final int TOTXT_H = 23;
    private static final int AMOUNTTXT_W = 90;
    private static final int AMOUNTTXT_H = 23;
    public static final int TYPE_GRANT = 0;
    public static final int TYPE_SEND = 1;
    private static final int AMOUNTTXT_ID = 1;
    private static final int DOWNBUTT_ID = 2;
    private static final int DOBUTT_ID = 3;
    private int type;
    private double amount;
    private int toDbId;
    private String toName;
    private GuiTextField toTxt;
    private GuiLabel doButt;

    public GuiTransfer(Player player, int type) {
        super((Plugin)Bank.plugin, Msgs.msg[type == 0 ? 6 : 5], 2, null);
        this.setCallback(new DlgHandler());
        this.type = type;
        GuiLayout layout = this.addNewLayoutChild(1, 8);
        GuiLabel lbl = new GuiLabel(Msgs.msg[7], 0.0f, 0.0f, false);
        layout.addChild((GuiElement)lbl);
        GuiTextField txt = new GuiTextField(0.0f, 0.0f, false, 90.0f, 23.0f, false);
        layout.addChild((GuiElement)txt, Integer.valueOf(1));
        lbl = new GuiLabel(Bank.currencySymbol, 0.0f, 0.0f, false);
        layout.addChild((GuiElement)lbl);
        this.toDbId = 0;
        layout = this.addNewLayoutChild(1, 8);
        lbl = new GuiLabel(Msgs.msg[8], 0.0f, 0.0f, false);
        layout.addChild((GuiElement)lbl);
        this.toTxt = new GuiTextField(0.0f, 0.0f, false, 132.0f, 23.0f, false);
        layout.addChild((GuiElement)this.toTxt);
        GuiImage img = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        layout.addChild((GuiElement)img, Integer.valueOf(2));
        RWGui.setImage((GuiImage)img, (int)0);
        layout = this.addNewLayoutChild(1, 1);
        this.doButt = new GuiLabel(Msgs.msg[9], 0.0f, 0.0f, false);
        layout.addChild((GuiElement)this.doButt, Integer.valueOf(3));
        this.doButt.setColor(0x404040FF);
        this.doButt.setClickable(false);
    }

    private void updateDoButton() {
        boolean complete = this.toDbId != 0 && this.amount > 0.0;
        this.doButt.setColor(complete ? 6344959 : 0x404040FF);
        this.doButt.setClickable(complete);
    }

    private class DlgHandler
    implements RWGui.RWGuiCallback {
        private DlgHandler() {
        }

        public void onCall(Player player, int id, Object data) {
            switch (id) {
                case 1: {
                    if (data == null) break;
                    Double temp = Bank.toDouble((String)data);
                    GuiTransfer.this.amount = temp == null ? 0.0 : temp;
                    GuiTransfer.this.updateDoButton();
                    break;
                }
                case 2: {
                    GuiTransfer.this.push(player, (GuiModalWindow)new GuiUsersMenu((Plugin)Bank.plugin, Msgs.msg[10], (RWGui.RWGuiCallback)new UserMenuHandler(), -1));
                    break;
                }
                case 3: {
                    String text;
                    int retVal = Db.transfer(GuiTransfer.this.type == 0 ? -1 : player.getDbID(), GuiTransfer.this.toDbId, GuiTransfer.this.amount, null);
                    switch (retVal) {
                        case -2: {
                            text = Msgs.msg[11];
                            break;
                        }
                        case -3: {
                            text = Msgs.msg[12];
                            break;
                        }
                        case -4: {
                            text = Msgs.msg[13];
                            break;
                        }
                        case 0: {
                            text = Msgs.msg[14];
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    GuiTransfer.this.poppush(player, (GuiModalWindow)new GuiMessageBox((Plugin)Bank.plugin, player, Msgs.msg[0], text, 0));
                }
            }
        }
    }

    private class UserMenuHandler
    implements RWGui.RWGuiCallback {
        private UserMenuHandler() {
        }

        public void onCall(Player player, int id, Object name) {
            if (id == -1) {
                return;
            }
            GuiTransfer.this.toDbId = id;
            GuiTransfer.this.toName = (String)name;
            GuiTransfer.this.toTxt.setText(GuiTransfer.this.toName);
            GuiTransfer.this.updateDoButton();
        }
    }
}

