/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.bank;

import com.vistamaresoft.bank.Bank;
import com.vistamaresoft.bank.Msgs;
import com.vistamaresoft.bankintf.BankIntf;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.database.Database;
import net.risingworld.api.objects.Player;

public class Db {
    private static Map<Integer, PlayerData> accounts = null;
    private static TreeMap<String, Integer> nameMap = null;
    private static Database db = null;
    private static final double CURR2ACCT_FACTOR = 100.0;
    private static final long TIMESTAMP2SYSTEMTIME = 1000L;
    private static final String UNKNOWN_NAME = "(??)";

    static void init(Plugin plugin) {
        if (db == null) {
            db = plugin.getSQLiteConnection(String.valueOf(plugin.getPath()) + "/bank-" + plugin.getWorld().getName() + ".db");
        }
        db.execute("CREATE TABLE IF NOT EXISTS `accounts` (`id`          INTEGER PRIMARY KEY,`player_dbid` INTEGER NOT NULL DEFAULT ( 0 ),`name`        VARCHAR(64) NOT NULL DEFAULT ( '[NoName]' ),`balance`     INTEGER NOT NULL DEFAULT ( 0 ),UNIQUE (`player_dbid`) ON CONFLICT IGNORE);");
        db.execute("CREATE TABLE IF NOT EXISTS `transactions` (`id`        INTEGER PRIMARY KEY,`from_dbid` INTEGER NOT NULL DEFAULT ( 0 ),`to_dbid`   INTEGER NOT NULL DEFAULT ( 0 ),`date`      INTEGER NOT NULL DEFAULT ( 0 ),`amount`    INTEGER NOT NULL DEFAULT ( 0 ),`reason`    VARCHAR(64) NOT NULL DEFAULT ( '---' ));");
        db.execute("CREATE INDEX IF NOT EXISTS `from` ON `transactions` (`from_dbid`, `date`);");
        db.execute("CREATE INDEX IF NOT EXISTS `to` ON `transactions` (`to_dbid`, `date`);");
        Db.getAccounts();
    }

    static void deinit() {
        db.close();
        db = null;
    }

    protected static Double getBalance(int player_dbid) {
        Integer value = Db.accounts.get((Object)Integer.valueOf((int)player_dbid)).balance;
        return value == null ? null : Double.valueOf((double)value.intValue() / 100.0);
    }

    protected static int transfer(int from_dbid, int to_dbid, double amount, String reason) {
        int amt = (int)Math.round(amount * 100.0);
        Integer from_balance = Db.accounts.get((Object)Integer.valueOf((int)from_dbid)).balance;
        if (from_balance == null) {
            return -2;
        }
        if (from_balance < amt) {
            return -4;
        }
        Integer to_balance = Db.accounts.get((Object)Integer.valueOf((int)to_dbid)).balance;
        if (to_balance == null) {
            return -3;
        }
        if (reason == null || reason.isEmpty()) {
            reason = from_dbid == 0 ? Msgs.msg[21] : (from_dbid == -1 ? Msgs.msg[22] : "");
        }
        db.executeUpdate("BEGIN TRANSACTION;");
        if (from_dbid != 0 && from_dbid != -1) {
            db.executeUpdate("UPDATE OR ROLLBACK `accounts` SET `balance`=" + (from_balance - amt) + " WHERE `player_dbid`=" + from_dbid + ";");
        }
        if (to_dbid != 0 && to_dbid != -1) {
            db.executeUpdate("UPDATE OR ROLLBACK `accounts` SET `balance`=" + (to_balance + amt) + " WHERE `player_dbid`=" + to_dbid + ";");
        }
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (PreparedStatement stmt = db.getConnection().prepareStatement("INSERT INTO `transactions` (`from_dbid`,`to_dbid`,`date`,`amount`,`reason`) VALUES (" + from_dbid + "," + to_dbid + "," + System.currentTimeMillis() / 1000L + "," + amt + ",?);");){
                stmt.setString(1, reason);
                stmt.executeUpdate();
                db.execute("COMMIT");
                if (from_dbid != 0 && from_dbid != -1) {
                    Db.accounts.get((Object)Integer.valueOf((int)from_dbid)).balance = from_balance - amt;
                }
                if (to_dbid != 0 && to_dbid != -1) {
                    Db.accounts.get((Object)Integer.valueOf((int)to_dbid)).balance = to_balance + amt;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    protected static TreeMap<String, Integer> getPlayerNamesToDbIdMap(int myself) {
        if (nameMap == null) {
            nameMap = new TreeMap();
            for (Map.Entry<Integer, PlayerData> entry : accounts.entrySet()) {
                if (entry.getKey() == myself) continue;
                nameMap.put(entry.getValue().name, entry.getKey());
            }
        }
        return nameMap;
    }

    protected static void initPlayer(Player player) {
        int id = player.getDbID();
        String name = player.getName();
        db.executeUpdate(" INSERT OR IGNORE INTO `accounts` (`player_dbid`,`name`,`balance`) VALUES (" + id + ",'" + name + "'," + Bank.initialAmount + ");");
        if (accounts.get(id) == null) {
            accounts.put(id, new PlayerData(name, Bank.initialAmount));
        }
    }

    protected static BankIntf.TransactionData[] getTransactions(int playerDbId, long fromTimeStamp, long toTimeStamp) {
        String query = "SELECT * FROM `transactions` WHERE (`from_dbid` = " + playerDbId + " OR `to_dbid` = " + playerDbId + ") AND `date` >= " + fromTimeStamp + " AND `date` <= " + toTimeStamp + " ORDER BY `date` DESC";
        ArrayList<BankIntf.TransactionData> transactions = new ArrayList<BankIntf.TransactionData>();
        try {
            Throwable throwable = null;
            Object var8_8 = null;
            try (ResultSet result = db.executeQuery(query);){
                while (result.next()) {
                    String name;
                    int amount = result.getInt(5);
                    int dbId = result.getInt(2);
                    if (dbId == playerDbId) {
                        amount = -amount;
                        dbId = result.getInt(3);
                    }
                    if ((name = Db.accounts.get((Object)Integer.valueOf((int)dbId)).name) == null) {
                        name = UNKNOWN_NAME;
                    }
                    BankIntf.TransactionData trans = new BankIntf.TransactionData(result.getInt(1), dbId, name, (long)result.getInt(4) * 1000L, (double)amount / 100.0, result.getString(6));
                    transactions.add(trans);
                }
                result.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return transactions.toArray(new BankIntf.TransactionData[transactions.size()]);
    }

    private static void getAccounts() {
        accounts = new HashMap<Integer, PlayerData>();
        accounts.put(-1, new PlayerData(Msgs.msg[19], Integer.MAX_VALUE));
        accounts.put(0, new PlayerData(Msgs.msg[20], Integer.MAX_VALUE));
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (ResultSet result = db.executeQuery("SELECT `player_dbid`,`name`, `balance` FROM `accounts`");){
                while (result.next()) {
                    int dbid = result.getInt(1);
                    String name = result.getString(2);
                    int balance = result.getInt(3);
                    accounts.put(dbid, new PlayerData(name, balance));
                }
                result.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static class PlayerData {
        public String name;
        public int balance;

        public PlayerData(String name, int balance) {
            this.name = name;
            this.balance = balance;
        }
    }
}

