/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.bank;

import com.vistamaresoft.bank.Bank;
import com.vistamaresoft.bank.Msgs;
import com.vistamaresoft.bankintf.BankIntf;
import com.vistamaresoft.rwgui.GuiDialogueBox;
import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.GuiTableLayout;
import com.vistamaresoft.rwgui.RWGui;
import java.util.Date;
import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;

public class GuiStatement
extends GuiDialogueBox {
    private static final int NUM_OF_COLUMNS = 4;
    private static final int NUM_OF_ROWS = 12;
    private static final int UPBUTT_ID = 1;
    private static final int DOWNBUTT_ID = 2;
    private static final int DOBUTT_ID = 3;
    private GuiLabel countLabel;
    private GuiImage upButt;
    private GuiImage downButt;
    private GuiLabel doButt;
    private GuiLabel[] statmCells;
    private int firstItem;
    private int numOfActualRows;
    private BankIntf.TransactionData[] transactions;

    public GuiStatement(Player player, BankIntf.TransactionData[] transactions) {
        super((Plugin)Bank.plugin, Msgs.msg[15], 2, null);
        this.setCallback(new DlgHandler());
        this.transactions = transactions;
        this.firstItem = 0;
        this.countLabel = new GuiLabel(0.0f, 0.0f, false);
        this.addChild((GuiElement)this.countLabel);
        this.numOfActualRows = transactions.length;
        if (this.numOfActualRows > 12) {
            this.numOfActualRows = 12;
        }
        GuiLayout layout = this.addNewLayoutChild(1, 1);
        if (transactions.length > 0) {
            GuiLayout layout2 = layout.addNewTableLayoutChild(4, this.numOfActualRows, 0);
            ((GuiTableLayout)layout2).setColFlag(3, 2);
            this.statmCells = new GuiLabel[this.numOfActualRows * 4];
            int i = 0;
            while (i < this.numOfActualRows * 4) {
                this.statmCells[i] = new GuiLabel(0.0f, 0.0f, false);
                layout2.addChild((GuiElement)this.statmCells[i]);
                ++i;
            }
            if (transactions.length > this.numOfActualRows) {
                layout2 = layout.addNewLayoutChild(2, 32);
                this.upButt = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
                RWGui.setImage((GuiImage)this.upButt, (int)3);
                layout2.addChild((GuiElement)this.upButt, Integer.valueOf(1));
                this.downButt = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
                RWGui.setImage((GuiImage)this.downButt, (int)0);
                layout2.addChild((GuiElement)this.downButt, Integer.valueOf(2));
            }
            this.updateCells();
        } else {
            this.countLabel.setText("0/0");
            layout.addChild((GuiElement)new GuiLabel(Msgs.msg[16], 0.0f, 0.0f, false));
        }
        layout = this.addNewLayoutChild(1, 1);
        this.doButt = new GuiLabel(Msgs.msg[17], 0.0f, 0.0f, false);
        layout.addChild((GuiElement)this.doButt, Integer.valueOf(3));
        this.doButt.setColor(6344959);
    }

    private void updateCells() {
        if (this.transactions == null || this.transactions.length < 1) {
            this.countLabel.setText("0/0");
            return;
        }
        this.countLabel.setText(String.valueOf(this.firstItem + 1) + "-" + (this.firstItem + this.numOfActualRows) + "/" + this.transactions.length);
        int count = 0;
        int i = 0;
        while (i < this.numOfActualRows) {
            BankIntf.TransactionData currTrans = this.transactions[this.firstItem + i];
            this.statmCells[count].setText(String.format("%tF", new Date(currTrans.timeStamp)));
            this.statmCells[count + 1].setText(currTrans.name);
            this.statmCells[count + 2].setText(currTrans.reason);
            this.statmCells[count + 3].setText(String.format("%.2f", currTrans.amount));
            this.statmCells[count + 3].setFontColor(currTrans.amount > 0.0 ? -1 : -16776961);
            count += 4;
            ++i;
        }
        if (this.numOfActualRows < this.transactions.length) {
            this.upButt.setVisible(this.firstItem > 0);
            this.downButt.setVisible(this.firstItem + 12 < this.transactions.length);
        }
    }

    private class DlgHandler
    implements RWGui.RWGuiCallback {
        private DlgHandler() {
        }

        public void onCall(Player player, int id, Object data) {
            switch (id) {
                case 1: {
                    GuiStatement guiStatement = GuiStatement.this;
                    guiStatement.firstItem = guiStatement.firstItem - 12;
                    if (GuiStatement.this.firstItem < 0) {
                        GuiStatement.this.firstItem = 0;
                    }
                    GuiStatement.this.updateCells();
                    break;
                }
                case 2: {
                    GuiStatement guiStatement = GuiStatement.this;
                    guiStatement.firstItem = guiStatement.firstItem + 12;
                    if (GuiStatement.this.firstItem + 12 > GuiStatement.this.transactions.length) {
                        GuiStatement.this.firstItem = GuiStatement.this.transactions.length - 12;
                    }
                    GuiStatement.this.updateCells();
                    break;
                }
                case 3: {
                    GuiStatement.this.pop(player);
                }
            }
        }
    }
}

