/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.bank;

import com.vistamaresoft.bank.Db;
import com.vistamaresoft.bank.GuiStatement;
import com.vistamaresoft.bank.MainMenu;
import com.vistamaresoft.bank.Msgs;
import com.vistamaresoft.bankintf.BankIntf;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Player;

public class Bank
extends Plugin
implements Listener,
BankIntf {
    public static final int ERR_SUCCESS = 0;
    public static final int ERR_DB = -1;
    public static final int ERR_FROM_ACCOUNT_UNKNOWN = -2;
    public static final int ERR_TO_ACCOUNT_UNKNOWN = -3;
    public static final int ERR_NOT_ENOUGH_MONEY = -4;
    private static final String localeLanguageDef = "en";
    protected static String commandPrefix = "/bank";
    protected static String currencyName = "Euro";
    protected static String currencySymbol = "EUR";
    protected static int initialAmount = 0;
    protected static Locale locale;
    protected static final String version = "0.2.0";
    private static final String publicName = "VistaMare Bank";
    protected static Bank plugin;

    public void onEnable() {
        plugin = this;
        this.initSettings();
        Msgs.init(this.getPath(), locale);
        Db.init(this);
        this.registerEventListener(this);
        System.out.println("BANK 0.2.0 loaded successfully!");
    }

    public void onDisable() {
        this.unregisterEventListener(this);
        Db.deinit();
        System.out.println("BANK 0.2.0 unloaded successfully!");
    }

    @EventMethod
    public void onConnect(PlayerConnectEvent event) {
        Db.initPlayer(event.getPlayer());
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent event) {
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equals(commandPrefix)) {
            this.mainGui(event.getPlayer());
        }
    }

    @Override
    public String getCurrencyName(int number) {
        return currencyName;
    }

    @Override
    public String getCurrencySymbol() {
        return currencySymbol;
    }

    @Override
    public boolean hasAvailableMoney(int player_dbid, double amount) {
        Double balance = Db.getBalance(player_dbid);
        return balance != null && balance >= amount;
    }

    @Override
    public Double getBalance(int player_dbid) {
        return Db.getBalance(player_dbid);
    }

    @Override
    public int transferMoney(int from_dbid, int to_dbid, double amount, String reason) {
        if (amount < 0.0) {
            amount = -amount;
        }
        return Db.transfer(from_dbid, to_dbid, amount, reason);
    }

    @Override
    public BankIntf.TransactionData[] getTransactions(int player_dbId, long fromTimeStamp, long toTimeStamp) {
        return Db.getTransactions(player_dbId, fromTimeStamp, toTimeStamp);
    }

    public String getPublicName() {
        return publicName;
    }

    public void mainGui(Player player) {
        MainMenu guiMenu = new MainMenu(player);
        guiMenu.show(player);
    }

    protected void showBalance(Player player) {
        Double balance = Db.getBalance(player.getDbID());
        if (balance == null) {
            balance = 0.0;
        }
        player.sendTextMessage(String.format(Msgs.msg[18], currencySymbol, balance));
    }

    protected void showStatement(Player player) {
        BankIntf.TransactionData[] transactions = Db.getTransactions(player.getDbID(), 0L, Long.MAX_VALUE);
        GuiStatement dlgBox = new GuiStatement(player, transactions);
        dlgBox.show(player);
    }

    private void initSettings() {
        String strLocale;
        Properties settings = new Properties();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");){
                settings.load(in);
                commandPrefix = "/" + settings.getProperty("command", commandPrefix);
                currencyName = settings.getProperty("currencyName", currencyName);
                currencySymbol = settings.getProperty("currencySymbol", currencySymbol);
                initialAmount = Integer.parseInt(settings.getProperty("initialAmount", Integer.toString(initialAmount)));
                strLocale = settings.getProperty("locale", localeLanguageDef);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            strLocale = localeLanguageDef;
        }
        String[] localeParams = strLocale.split("-");
        locale = localeParams.length > 0 ? (localeParams.length > 1 && localeParams[2].length() > 0 ? (localeParams.length > 2 && localeParams[2].length() > 0 ? new Locale(localeParams[0], localeParams[1], localeParams[2]) : new Locale(localeParams[0], localeParams[1])) : new Locale(localeParams[0])) : new Locale(localeLanguageDef);
    }

    protected static Integer toInteger(String txt) {
        int val;
        if (txt == null) {
            return null;
        }
        try {
            val = Integer.decode(txt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }

    protected static Double toDouble(String txt) {
        double val;
        if (txt == null) {
            return null;
        }
        try {
            val = Double.valueOf(txt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }
}

