/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

public class Vector3f {
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public float x;
    public float y;
    public float z;

    public Vector3f() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f(Vector3f copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
    }

    public Vector3f set(Vector3f vector) {
        return this.set(vector.x, vector.y, vector.z);
    }

    public Vector3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3f setX(float x) {
        this.x = x;
        return this;
    }

    public Vector3f setY(float y) {
        this.y = y;
        return this;
    }

    public Vector3f setZ(float z) {
        this.z = z;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float dot(Vector3f other) {
        return this.dot(other.x, other.y, other.z);
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(Vector3f other) {
        return (float)Math.sqrt(this.distanceSquared(other.x, other.y, other.z));
    }

    public float distance(float x, float y, float z) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z));
    }

    public float distanceSquared(Vector3f other) {
        return this.distanceSquared(other.x, other.y, other.z);
    }

    public float distanceSquared(float x, float y, float z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return (float)(dx * dx + dy * dy + dz * dz);
    }

    public Vector3f addLocal(Vector3f other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public Vector3f addLocal(float addX, float addY, float addZ) {
        this.x += addX;
        this.y += addY;
        this.z += addZ;
        return this;
    }

    public Vector3f subtractLocal(Vector3f other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        return this;
    }

    public Vector3f subtractLocal(float subtractX, float subtractY, float subtractZ) {
        this.x -= subtractX;
        this.y -= subtractY;
        this.z -= subtractZ;
        return this;
    }

    public Vector3f multLocal(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3f multLocal(Vector3f other) {
        this.x *= other.x;
        this.y *= other.y;
        this.z *= other.z;
        return this;
    }

    public Vector3f multLocal(float multX, float multY, float multZ) {
        this.x *= this.x;
        this.y *= this.y;
        this.z *= this.z;
        return this;
    }

    public Vector3f divideLocal(float scalar) {
        float s = 1.0f / scalar;
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    public Vector3f divideLocal(Vector3f other) {
        this.x /= other.x;
        this.y /= other.y;
        this.z /= other.z;
        return this;
    }

    public Vector3f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f crossLocal(Vector3f other) {
        return this.crossLocal(other.x, other.y, other.z);
    }

    public Vector3f crossLocal(float v2x, float v2y, float v2z) {
        float nx = this.y * v2z - this.z * v2y;
        float ny = this.z * v2x - this.x * v2z;
        float nz = this.x * v2y - this.y * v2x;
        this.x = nx;
        this.y = ny;
        this.z = nz;
        return this;
    }

    public Vector3f normalizeLocal() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
        this.z /= l;
        return this;
    }

    public float angleBetween(Vector3f other) {
        float dot = this.dot(other);
        return (float)Math.acos(dot);
    }

    public Vector3f zero() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public boolean isUnitVector() {
        float len = this.length();
        return len >= 0.99f && len <= 1.01f;
    }

    public boolean isOrthogonal(Vector3f other) {
        return this.isOrthogonal(other.x, other.y, other.z);
    }

    public boolean isOrthogonal(float x, float y, float z) {
        float dot = this.dot(x, y, z);
        return dot >= 0.99f && dot <= 1.01f;
    }

    public Vector3f interpolateLocal(Vector3f finalVector, float mu) {
        this.x = (1.0f - mu) * this.x + mu * finalVector.x;
        this.y = (1.0f - mu) * this.y + mu * finalVector.y;
        this.z = (1.0f - mu) * this.z + mu * finalVector.z;
        return this;
    }

    public boolean equals(Object o) {
        if (o.getClass() != Vector3f.class) {
            return false;
        }
        Vector3f compare = (Vector3f)o;
        return this.x == compare.x && this.y == compare.y && this.z == compare.z;
    }

    public boolean equals(float x, float y, float z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Float.floatToIntBits(this.x);
        hash = 47 * hash + Float.floatToIntBits(this.y);
        hash = 47 * hash + Float.floatToIntBits(this.z);
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

