/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import java.util.concurrent.atomic.AtomicInteger;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;
import pluginapi.manager.PluginElementManager;

public abstract class WorldElement {
    int id;
    Vector3f position = new Vector3f();
    Quaternion rotation = new Quaternion();
    float visibleRange = 100.0f;
    private static AtomicInteger id_counter = new AtomicInteger();

    WorldElement() {
        this.id = id_counter.getAndIncrement();
    }

    public int getID() {
        return this.id;
    }

    public void setPosition(Vector3f position) {
        if (!this.position.equals(position)) {
            this.position.set(position);
            PluginElementManager.updateElementPosition((int)this.id, (float)position.x, (float)position.y, (float)position.z, (float)0.0f);
        }
    }

    public void setPosition(float x, float y, float z) {
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            this.position.set(x, y, z);
            PluginElementManager.updateElementPosition((int)this.id, (float)x, (float)y, (float)z, (float)0.0f);
        }
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void moveTo(Vector3f position, float speed) {
        if (!this.position.equals(position)) {
            this.position.set(position);
            PluginElementManager.updateElementPosition((int)this.id, (float)position.x, (float)position.y, (float)position.z, (float)speed);
        }
    }

    public void moveTo(float x, float y, float z, float speed) {
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            this.position.set(x, y, z);
            PluginElementManager.updateElementPosition((int)this.id, (float)x, (float)y, (float)z, (float)speed);
        }
    }

    public void setRotation(Quaternion rotation) {
        if (!this.rotation.equals(rotation)) {
            this.rotation.set(rotation);
            PluginElementManager.updateElementRotation((int)this.id, (float)rotation.x, (float)rotation.y, (float)rotation.z, (float)rotation.w);
        }
    }

    public void setRotation(float pitch, float yaw, float roll) {
        this.rotation.fromAngles(pitch, yaw, roll);
        PluginElementManager.updateElementRotation((int)this.id, (float)this.rotation.x, (float)this.rotation.y, (float)this.rotation.z, (float)this.rotation.w);
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void setVisibleRange(float range) {
        if (this.visibleRange != range) {
            this.visibleRange = range;
        }
    }

    public float getVisibleRange() {
        return this.visibleRange;
    }

    public void destroy() {
        PluginElementManager.destroyElement((WorldElement)this);
    }

    public void refresh() {
    }
}

