/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.util.concurrent.atomic.AtomicInteger;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;

public class Area {
    public static final Area INFINITE;
    int globalID = id_counter.getAndIncrement();
    Vector3i startChunk;
    Vector3i startBlock;
    Vector3i endChunk;
    Vector3i endBlock;
    private static final AtomicInteger id_counter;

    public Area() {
        this.startChunk = new Vector3i();
        this.startBlock = new Vector3i();
        this.endChunk = new Vector3i();
        this.endBlock = new Vector3i();
    }

    public Area(Vector3i startChunk, Vector3i startBlock, Vector3i endChunk, Vector3i endBlock) {
        this.startChunk = new Vector3i(startChunk);
        this.startBlock = new Vector3i(startBlock);
        this.endChunk = new Vector3i(endChunk);
        this.endBlock = new Vector3i(endBlock);
    }

    public Area(int startcx, int startcy, int startcz, int startbx, int startby, int startbz, int endcx, int endcy, int endcz, int endbx, int endby, int endbz) {
        this.startChunk = new Vector3i(startcx, startcy, startcz);
        this.startBlock = new Vector3i(startbx, startby, startbz);
        this.endChunk = new Vector3i(endcx, endcy, endcz);
        this.endBlock = new Vector3i(endbx, endby, endbz);
    }

    public Area(Vector3f globalStartPosition, Vector3f globalEndPosition) {
        this.startChunk = new Vector3i();
        this.startBlock = new Vector3i();
        this.endChunk = new Vector3i();
        this.endBlock = new Vector3i();
        Utils.ChunkUtils.getChunkAndBlockPosition(globalStartPosition, this.startChunk, this.startBlock);
        Utils.ChunkUtils.getChunkAndBlockPosition(globalEndPosition, this.endChunk, this.endBlock);
    }

    public Vector3i getStartChunkPosition() {
        return this.startChunk;
    }

    public Vector3i getStartBlockPosition() {
        return this.startBlock;
    }

    public Vector3i getEndChunkPosition() {
        return this.endChunk;
    }

    public Vector3i getEndBlockPosition() {
        return this.endBlock;
    }

    public int getID() {
        return this.globalID;
    }

    public boolean rearrange() {
        int bz;
        int cz;
        int by;
        int cy;
        int bx;
        int cx;
        boolean arrange = false;
        if (this.startChunk.x == this.endChunk.x) {
            if (this.startBlock.x > this.endBlock.x) {
                cx = this.endChunk.x;
                bx = this.endBlock.x;
                this.startChunk.x = this.endChunk.x;
                this.startBlock.x = this.endBlock.x;
                this.endChunk.x = cx;
                this.endBlock.x = bx;
                arrange = true;
            }
        } else if (this.startChunk.x > this.endChunk.x) {
            cx = this.endChunk.x;
            bx = this.endBlock.x;
            this.startChunk.x = this.endChunk.x;
            this.startBlock.x = this.endBlock.x;
            this.endChunk.x = cx;
            this.endBlock.x = bx;
            arrange = true;
        }
        if (this.startChunk.y == this.endChunk.y) {
            if (this.startBlock.y > this.endBlock.y) {
                cy = this.endChunk.y;
                by = this.endBlock.y;
                this.startChunk.y = this.endChunk.y;
                this.startBlock.y = this.endBlock.y;
                this.endChunk.y = cy;
                this.endBlock.y = by;
                arrange = true;
            }
        } else if (this.startChunk.y > this.endChunk.y) {
            cy = this.endChunk.y;
            by = this.endBlock.y;
            this.startChunk.y = this.endChunk.y;
            this.startBlock.y = this.endBlock.y;
            this.endChunk.y = cy;
            this.endBlock.y = by;
            arrange = true;
        }
        if (this.startChunk.z == this.endChunk.z) {
            if (this.startBlock.z > this.endBlock.z) {
                cz = this.endChunk.z;
                bz = this.endBlock.z;
                this.startChunk.z = this.endChunk.z;
                this.startBlock.z = this.endBlock.z;
                this.endChunk.z = cz;
                this.endBlock.z = bz;
                arrange = true;
            }
        } else if (this.startChunk.z > this.endChunk.z) {
            cz = this.endChunk.z;
            bz = this.endBlock.z;
            this.startChunk.z = this.endChunk.z;
            this.startBlock.z = this.endBlock.z;
            this.endChunk.z = cz;
            this.endBlock.z = bz;
            arrange = true;
        }
        return arrange;
    }

    public String toString() {
        return "(" + this.startChunk + ", " + this.startBlock + ", " + this.endChunk + ", " + this.endBlock + ")";
    }

    public boolean equals(Object o) {
        if (o.getClass() != Area.class) {
            return false;
        }
        Area compare = (Area)o;
        return this.globalID == compare.globalID;
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + this.globalID;
        return hash;
    }

    static {
        id_counter = new AtomicInteger();
        INFINITE = new Area(-134217727, -33554431, -134217727, 0, 0, 0, 0x7FFFFFF, 0x1FFFFFF, 0x7FFFFFF, 15, 63, 15);
    }
}

