/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import commons.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import pluginapi.manager.PluginElementManager;

public final class ImageInformation {
    private byte[] data;
    private String filename;
    private String extension;
    private String md5;

    public ImageInformation(String path) throws IOException {
        this(new File(path));
    }

    public ImageInformation(File file) throws IOException {
        if (file != null) {
            this.filename = file.getName();
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (file.isDirectory()) {
                throw new FileNotFoundException("You have to specify a single file instead of a directory");
            }
            if (!this.checkFileExtension(this.filename)) {
                throw new UnsupportedOperationException("File format of \"" + file.getName() + "\" not supported!");
            }
            int dot = this.filename.lastIndexOf(46);
            this.extension = this.filename.substring(dot + 1);
            this.filename = file.getName().substring(0, dot);
            this.data = Utils.FileUtils.readBytesFromFile((File)file);
            this.md5 = Utils.FileUtils.getMd5((File)file);
            PluginElementManager.registerImageInformation((ImageInformation)this);
        }
    }

    private boolean checkFileExtension(String name) {
        return (name = name.toLowerCase()).endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".png") || name.endsWith(".gif") || name.endsWith(".tga") || name.endsWith(".dds");
    }

    public byte[] getData() {
        return this.data;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getChecksum() {
        return this.md5;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ImageInformation)) {
            return false;
        }
        ImageInformation compare = (ImageInformation)o;
        return this.filename.equals(compare.filename) && this.extension.equals(compare.extension) && this.md5.equals(compare.md5);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.filename);
        hash = 41 * hash + Objects.hashCode(this.extension);
        hash = 41 * hash + Objects.hashCode(this.md5);
        return hash;
    }
}

