/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.ups;

import com.vistamaresoft.bankintf.BankIntf;
import com.vistamaresoft.ups.Db;
import com.vistamaresoft.ups.MainMenu;
import com.vistamaresoft.ups.Msgs;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;

public class Ups
extends Plugin
implements Listener {
    protected static final String localeLanguageDef = "en";
    protected static String commandPrefix = "/ups";
    protected static String bankPluginName = "com.vms.Bank";
    protected static double costPerItem = 2.0;
    protected static double costPer4Items = 6.5;
    protected static double costPer16Items = 20.0;
    protected static double costPer64Items = 64.0;
    protected static Locale locale;
    public static final String key_menu = "com.vms.upsMenu";
    public static final String VERSION = "0.1.0";
    public static final String PUBLIC_NAME = "UPS";
    public static final int ERR_SUCCESS = 0;
    public static final int ERR_INVALID_ARG = -1;
    public static final int ERR_DB = -2;
    public static final int ERR_WRONG_RECIPIENT = -3;
    public static final int ERR_CANT_DELIVER = -4;
    public static final int ERR_NOT_ENOUGH_MONEY = -5;
    protected static Ups plugin;
    protected static BankIntf bankPlugin;
    protected static String currencySymbol;
    private static boolean bankLookedFor;

    static {
        bankLookedFor = false;
    }

    public void onEnable() {
        plugin = this;
        this.initSettings();
        Msgs.init(this.getPath(), locale);
        Db.init();
        this.registerEventListener(this);
        System.out.println("UPS 0.1.0 loaded successfully!");
    }

    public void onDisable() {
        this.unregisterEventListener(this);
        Db.deinit();
        System.out.println("UPS 0.1.0 unloaded successfully!");
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        if (!bankLookedFor) {
            BankIntf tempBankPlugin = (BankIntf)this.getPluginByName(bankPluginName);
            if (tempBankPlugin != null && tempBankPlugin instanceof BankIntf) {
                bankPlugin = tempBankPlugin;
                currencySymbol = bankPlugin.getCurrencySymbol();
            }
            bankLookedFor = true;
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equals(commandPrefix)) {
            this.mainGui(event.getPlayer());
        }
    }

    public String getPublicName() {
        return PUBLIC_NAME;
    }

    public void mainGui(Player player) {
        Object obj = player.getAttribute(key_menu);
        MainMenu guiMenu = obj == null || !(obj instanceof MainMenu) ? new MainMenu(player) : (MainMenu)((Object)obj);
        guiMenu.show(player);
        player.setAttribute(key_menu, (Object)guiMenu);
    }

    public int send(Player player, Inventory.SlotType slotType, int slotIdx, int quantity, String toName, int toDbId, double cost, double cashOnDel) {
        int retVal;
        Inventory inv = player.getInventory();
        Item item = inv.getItem(slotIdx, slotType);
        if (item == null) {
            return -1;
        }
        if (item.getStacksize() < quantity) {
            quantity = item.getStacksize();
        }
        if ((retVal = Db.send(player, item.getTypeID(), item.getVariation(), quantity, toName, toDbId, cost, cashOnDel)) > 0) {
            inv.removeItem(slotIdx, slotType, quantity);
            Collection players = this.getServer().getAllPlayers();
            if (players != null) {
                for (Player currPlayer : players) {
                    if (currPlayer.getDbID() != toDbId) continue;
                    currPlayer.sendTextMessage(Msgs.msg[29]);
                    break;
                }
            }
        }
        return retVal;
    }

    public int deliver(Player player, int parcelId) {
        int retVal = Db.deliver(player, parcelId);
        return retVal;
    }

    private void initSettings() {
        String strLocale;
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");
            settings.load(in);
            in.close();
            commandPrefix = "/" + settings.getProperty("command", commandPrefix);
            bankPluginName = settings.getProperty("bankPlugin", bankPluginName);
            Double temp = Ups.toDouble(settings.getProperty("costPerItem", Double.toString(costPerItem)));
            costPerItem = temp != null ? temp : costPerItem;
            temp = Ups.toDouble(settings.getProperty("costPer4Items", Double.toString(costPer4Items)));
            costPer4Items = temp != null ? temp : costPer4Items;
            temp = Ups.toDouble(settings.getProperty("costPer16Items", Double.toString(costPer16Items)));
            costPer16Items = temp != null ? temp : costPer16Items;
            temp = Ups.toDouble(settings.getProperty("costPer64Items", Double.toString(costPer64Items)));
            costPer64Items = temp != null ? temp : costPer64Items;
            strLocale = settings.getProperty("locale", localeLanguageDef);
        }
        catch (IOException e) {
            strLocale = localeLanguageDef;
        }
        String[] localeParams = strLocale.split("-");
        locale = localeParams.length > 0 ? (localeParams.length > 1 && localeParams[2].length() > 0 ? (localeParams.length > 2 && localeParams[2].length() > 0 ? new Locale(localeParams[0], localeParams[1], localeParams[2]) : new Locale(localeParams[0], localeParams[1])) : new Locale(localeParams[0])) : new Locale(localeLanguageDef);
    }

    protected static Integer toInteger(String txt) {
        int val;
        if (txt == null) {
            return null;
        }
        try {
            val = Integer.decode(txt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }

    protected static Double toDouble(String txt) {
        double val;
        if (txt == null) {
            return null;
        }
        try {
            val = Double.valueOf(txt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }

    public static class Parcel {
        public int id = 0;
        public int fromDbId;
        public String fromName;
        public int toDbId;
        public String toName;
        public int itemId;
        public int itemVar;
        public int itemQty;
        public double cashOnDel;
        public long sentOn;
        public long recdOn;

        public Parcel(int fromDbId, String fromName, int toDbId, String toName, int itemId, int itemVar, int itemQty, double cashOnDel, long sentOn, long recdOn) {
            this.fromDbId = fromDbId;
            this.fromName = fromName;
            this.toDbId = toDbId;
            this.toName = toName;
            this.itemId = itemId;
            this.itemVar = itemVar;
            this.itemQty = itemQty;
            this.cashOnDel = cashOnDel;
            this.sentOn = sentOn;
            this.recdOn = recdOn;
        }

        public Parcel(int id, int fromDbId, String fromName, int toDbId, String toName, int itemId, int itemVar, int itemQty, double cashOnDel, long sentOn, long recdOn) {
            this(fromDbId, fromName, toDbId, toName, itemId, itemVar, itemQty, cashOnDel, sentOn, recdOn);
            this.id = id;
        }
    }
}

