/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.ups;

import com.vistamaresoft.rwgui.GuiDialogueBox;
import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.GuiTableLayout;
import com.vistamaresoft.rwgui.RWGui;
import com.vistamaresoft.ups.Db;
import com.vistamaresoft.ups.Msgs;
import com.vistamaresoft.ups.Ups;
import java.util.ArrayList;
import java.util.Date;
import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;

public class ShipGui
extends GuiDialogueBox {
    public static final int TYPE_RECEIVED = 0;
    public static final int TYPE_SENT = 1;
    public static final int PREVBUTT_ID = 1;
    public static final int NEXTBUTT_ID = 2;
    public static final int COLLECTBUTT_ID = 3;
    private int currParcel;
    private boolean empty;
    private ArrayList<Ups.Parcel> parcels;
    private int type;
    private GuiLabel countLbl;
    private GuiLabel fromToTxt;
    private GuiLabel descrTxt;
    private GuiLabel codTxt;
    private GuiLabel sentTxt;
    private GuiLabel recdTxt;
    private GuiImage prevButt;
    private GuiImage nextButt;
    private GuiLabel collectButt;

    public ShipGui(Player player, int type) {
        super((Plugin)Ups.plugin, Msgs.msg[type == 0 ? 14 : 15], 2, null);
        this.setCallback(new DlgHandler());
        this.type = type;
        int playerDbId = player.getDbID();
        this.parcels = type == 0 ? Db.getParcelsToPlayer(playerDbId) : Db.getParcelsFromPlayer(playerDbId);
        this.empty = this.parcels == null || this.parcels.size() < 1;
        GuiLayout layout = this.addNewLayoutChild(1, 0);
        this.countLbl = new GuiLabel(0.0f, 0.0f, false);
        layout.addChild((GuiElement)this.countLbl);
        if (this.empty) {
            this.currParcel = -1;
            layout = this.addNewLayoutChild(2, 9);
            this.countLbl.setText("0/0");
            layout.addChild((GuiElement)new GuiLabel(Msgs.msg[24], 0.0f, 0.0f, false));
        } else {
            this.currParcel = 0;
            layout = this.addNewTableLayoutChild(2, 5, 0);
            layout.addChild((GuiElement)new GuiLabel(Msgs.msg[type == 0 ? 16 : 17], 0.0f, 0.0f, false));
            this.fromToTxt = new GuiLabel(0.0f, 0.0f, false);
            layout.addChild((GuiElement)this.fromToTxt);
            layout.addChild((GuiElement)new GuiLabel(Msgs.msg[18], 0.0f, 0.0f, false));
            this.descrTxt = new GuiLabel(0.0f, 0.0f, false);
            layout.addChild((GuiElement)this.descrTxt);
            layout.addChild((GuiElement)new GuiLabel(Msgs.msg[20], 0.0f, 0.0f, false));
            this.codTxt = new GuiLabel(0.0f, 0.0f, false);
            layout.addChild((GuiElement)this.codTxt);
            layout.addChild((GuiElement)new GuiLabel(Msgs.msg[21], 0.0f, 0.0f, false));
            this.sentTxt = new GuiLabel(0.0f, 0.0f, false);
            layout.addChild((GuiElement)this.sentTxt);
            layout.addChild((GuiElement)new GuiLabel(Msgs.msg[22], 0.0f, 0.0f, false));
            this.recdTxt = new GuiLabel(0.0f, 0.0f, false);
            layout.addChild((GuiElement)this.recdTxt);
            ((GuiTableLayout)layout).setColFlag(0, 2);
            layout = this.addNewLayoutChild(1, 4);
            this.prevButt = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
            layout.addChild((GuiElement)this.prevButt, Integer.valueOf(1));
            RWGui.setImage((GuiImage)this.prevButt, (int)1);
            this.nextButt = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
            layout.addChild((GuiElement)this.nextButt, Integer.valueOf(2));
            RWGui.setImage((GuiImage)this.nextButt, (int)2);
            if (type == 0) {
                layout = this.addNewLayoutChild(1, 1);
                this.collectButt = new GuiLabel(Msgs.msg[25], 0.0f, 0.0f, false);
                layout.addChild((GuiElement)this.collectButt, Integer.valueOf(3));
                this.collectButt.setColor(6344959);
            }
        }
        this.updateDescr();
    }

    private void updateDescr() {
        if (!this.empty) {
            this.countLbl.setText(String.format("%d/%d", this.currParcel + 1, this.parcels.size()));
            Ups.Parcel parcel = this.parcels.get(this.currParcel);
            this.fromToTxt.setText(this.type == 0 ? parcel.fromName : parcel.toName);
            this.descrTxt.setText(String.format(Msgs.msg[19], parcel.itemId, parcel.itemQty, parcel.itemVar));
            this.codTxt.setText(String.format(Msgs.msg[11], parcel.cashOnDel, Ups.currencySymbol));
            this.sentTxt.setText(String.format("%tF", new Date(parcel.sentOn)));
            long recd = parcel.recdOn;
            this.recdTxt.setText(recd > 0L ? String.format("%tF", new Date(recd)) : Msgs.msg[23]);
            if (this.type == 0) {
                this.collectButt.setVisible(recd == 0L);
            }
            this.prevButt.setVisible(this.currParcel > 0);
            this.nextButt.setVisible(this.currParcel < this.parcels.size() - 1);
        }
    }

    private class DlgHandler
    implements RWGui.RWGuiCallback {
        private DlgHandler() {
        }

        public void onCall(Player player, int id, Object data) {
            block0 : switch (id) {
                case -1: {
                    return;
                }
                case 1: {
                    if (ShipGui.this.empty) break;
                    ShipGui shipGui = ShipGui.this;
                    shipGui.currParcel = shipGui.currParcel - 1;
                    if (ShipGui.this.currParcel < 0) {
                        ShipGui.this.currParcel = 0;
                        break;
                    }
                    ShipGui.this.updateDescr();
                    ShipGui.this.layout();
                    break;
                }
                case 2: {
                    if (ShipGui.this.empty) break;
                    ShipGui shipGui = ShipGui.this;
                    shipGui.currParcel = shipGui.currParcel + 1;
                    if (ShipGui.this.currParcel >= ShipGui.this.parcels.size()) {
                        ShipGui.this.currParcel = ShipGui.this.parcels.size() - 1;
                        break;
                    }
                    ShipGui.this.updateDescr();
                    ShipGui.this.layout();
                    break;
                }
                case 3: {
                    int retVal = Ups.plugin.deliver(player, ((Ups.Parcel)((ShipGui)ShipGui.this).parcels.get((int)((ShipGui)ShipGui.this).currParcel)).id);
                    switch (retVal) {
                        case -5: {
                            player.sendTextMessage(Msgs.msg[30]);
                            break block0;
                        }
                        case -4: {
                            player.sendTextMessage(Msgs.msg[31]);
                            break block0;
                        }
                        case 0: {
                            ((Ups.Parcel)((ShipGui)ShipGui.this).parcels.get((int)((ShipGui)ShipGui.this).currParcel)).recdOn = System.currentTimeMillis();
                            ShipGui.this.updateDescr();
                        }
                    }
                }
            }
        }
    }
}

