/****************************
	T e s t  -  A Rising World Java plug-in to test Area.

	Test.java - The main plug-in class

	Created by : Maurizio M. Gavioli 2016-11-15

	(C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
	Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)

*****************************/

package com.vistamaresoft.test;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerEnterAreaEvent;
import net.risingworld.api.events.player.PlayerLeaveAreaEvent;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.WorldArea;

public class Test extends Plugin implements Listener
{
	// FIELDS
	private class MyArea extends Area
	{
		protected String name;
		
		public MyArea(String name, Vector3f from, Vector3f to)
		{
			super(from, to);
			this.name	= name;
		}
	}

	private	MyArea	myArea;

	@Override
	public void onEnable()
	{
		myArea	= new MyArea("My area", new Vector3f(-20, -200, -20), new Vector3f(20, 200, 20));
		getServer().addArea(myArea);
		registerEventListener(this);
	}

	@Override
	public void onDisable()
	{
		unregisterEventListener(this);
		getServer().removeArea(myArea);
		myArea	= null;
	}

	@EventMethod
	public void onConnect(PlayerConnectEvent event)
	{
		WorldArea	worldArea	= new WorldArea(myArea);
		worldArea.setColor(0xFF000080);
		event.getPlayer().addWorldElement(worldArea);
	}

	@EventMethod
	public void onPlayerEnterArea(PlayerEnterAreaEvent event)
	{
		Area	area	= event.getArea();
		boolean	match	= area.equals(myArea);
		String name	= "";
		if (match)
			name	= ((MyArea)area).name;
		event.getPlayer().sendTextMessage("ENTER area '" + name + "'");
	}

	@EventMethod
	public void onPlayerLeaveArea(PlayerLeaveAreaEvent event)
	{
		Area	area	= event.getArea();
		boolean	match	= area.equals(myArea);
		String name	= "";
		if (match)
			name	= ((MyArea)area).name;
		event.getPlayer().sendTextMessage("LEAVE area '" + name + "'");
	}

}
