/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.text3d;

import de.galveston01.text3d.Text3D;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.events.player.gui.PlayerGuiInputEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.World3DText;

public class EditGui
implements Listener {
    private Text3D plugin;
    private Player p;
    private GuiPanel panel;
    private GuiLabel bAdd;
    private GuiLabel bCancel;
    private GuiTextField tName;
    private GuiTextField tPx;
    private GuiTextField tPy;
    private GuiTextField tPz;
    private GuiTextField tFs;
    private GuiTextField tRx;
    private GuiTextField tRy;
    private GuiTextField tRz;
    private GuiLabel lPx;
    private GuiLabel lPy;
    private GuiLabel lPz;
    private GuiLabel lFontD;
    private GuiLabel lFont;
    private GuiLabel lFs;
    private GuiLabel lFg;
    private GuiLabel lBg;
    private GuiLabel lAW;
    private GuiLabel lBB;
    private GuiLabel lRx;
    private GuiLabel lRy;
    private GuiLabel lRz;
    private GuiPanel pFg;
    private GuiPanel pBg;
    private GuiPanel pAW;
    private GuiPanel pBB;
    private Font[] fonts = new Font[]{Font.Default, Font.Default_Bold, Font.Default_Italic, Font.Default_Bold_Italic, Font.DefaultMono, Font.DefaultMono_Bold, Font.DefaultMono_Italic, Font.DefaultMono_Bold_Italic, Font.Console, Font.Handdrawn};
    private String[] sfonts = new String[]{"Default", "Default (bold)", "Default (italic)", "Default (bold&italic)", "Default Mono", "Default Mono (bold)", "Default Mono (italic)", "Default Mono (bold&italic)", "Console", "Handdrawn"};
    private int[] colors = new int[]{-1, 255, -16776961, -65281, 0xFF00FF, 0xFFFFFF, 255, -16711681, -120, 136, -16777080, -65400, 0xFF0088, 0xFFFF88, 136, -16711800, 0};
    private String txt = "name";
    private float px = 0.0f;
    private float py = 0.0f;
    private float pz = 0.0f;
    private int font = 0;
    private int fs = 20;
    private int fg = 1;
    private int bg = this.colors.length - 1;
    private boolean aw = false;
    private boolean bb = true;
    private float rx;
    private float ry;
    private float rz;
    private int id = 0;

    public EditGui(Text3D plugin, Player p, int id) {
        this.plugin = plugin;
        this.p = p;
        this.id = id;
        this.px = (float)((int)(plugin.texts.get((int)id).getPosition().x * 10000.0f)) / 10000.0f;
        this.py = (float)((int)(plugin.texts.get((int)id).getPosition().y * 10000.0f)) / 10000.0f;
        this.pz = (float)((int)(plugin.texts.get((int)id).getPosition().z * 10000.0f)) / 10000.0f;
        float[] r = plugin.texts.get(id).getRotation().toAngles();
        this.rx = (float)((int)(Utils.MathUtils.radianToDegree((float)r[0]) * 10000.0f)) / 10000.0f;
        this.ry = (float)((int)(Utils.MathUtils.radianToDegree((float)r[1]) * 10000.0f)) / 10000.0f;
        this.rz = (float)((int)(Utils.MathUtils.radianToDegree((float)r[2]) * 10000.0f)) / 10000.0f;
        this.txt = plugin.texts.get(id).getText();
        this.fs = plugin.texts.get(id).getFontsize();
        this.aw = plugin.texts.get(id).isAlwaysVisible();
        this.bb = plugin.texts.get(id).isBillboard();
        int i = 0;
        Font fc = plugin.texts.get(id).getFont();
        for (Font f : this.fonts) {
            if (fc.equals((Object)f)) {
                this.font = i;
                break;
            }
            ++i;
        }
        i = 0;
        int bgc = plugin.texts.get(id).getBackgroundColor();
        for (int tbg : this.colors) {
            if (bgc == tbg) {
                this.bg = i;
                break;
            }
            ++i;
        }
        i = 0;
        int fgc = plugin.texts.get(id).getFontColor();
        for (int tfg : this.colors) {
            if (fgc == tfg) {
                this.fg = i;
                break;
            }
            ++i;
        }
        plugin.registerEventListener(this);
        p.disableClientsideKeys(new int[]{1});
        p.setListenForKeyInput(true);
        p.setMouseCursorVisible(true);
        this.panel = new GuiPanel(0.5f, 0.5f, true, 0.8f, 0.8f, true);
        this.panel.setPivot(PivotPosition.Center);
        this.panel.setColor(153);
        p.addGuiElement((GuiElement)this.panel);
        this.tName = new GuiTextField(0.12f, 0.87f, true, 0.76f, 0.05f, true);
        this.tName.setText(this.txt);
        this.tName.setPivot(PivotPosition.TopLeft);
        this.tName.setFontColor(255);
        this.tName.setListenForInput(true);
        p.addGuiElement((GuiElement)this.tName);
        this.lPx = new GuiLabel(0.12f, 0.78f, true);
        this.lPx.setText("position x");
        this.lPx.setFontColor(-1);
        this.lPx.setPivot(PivotPosition.TopLeft);
        p.addGuiElement((GuiElement)this.lPx);
        this.tPx = new GuiTextField(0.17944443f, 0.8f, true, 0.16888888f, 0.05f, true);
        this.tPx.setPivot(PivotPosition.TopLeft);
        this.tPx.setFontColor(255);
        this.tPx.setListenForInput(true);
        this.tPx.setText(Float.toString(this.px));
        p.addGuiElement((GuiElement)this.tPx);
        this.lPy = new GuiLabel(0.38194445f, 0.78f, true);
        this.lPy.setText("position y");
        this.lPy.setFontColor(-1);
        this.lPy.setPivot(PivotPosition.TopLeft);
        p.addGuiElement((GuiElement)this.lPy);
        this.tPy = new GuiTextField(0.44527778f, 0.8f, true, 0.16888888f, 0.05f, true);
        this.tPy.setPivot(PivotPosition.TopLeft);
        this.tPy.setFontColor(255);
        this.tPy.setListenForInput(true);
        this.tPy.setText(Float.toString(this.py));
        p.addGuiElement((GuiElement)this.tPy);
        this.lPz = new GuiLabel(0.6477778f, 0.78f, true);
        this.lPz.setText("position z");
        this.lPz.setFontColor(-1);
        this.lPz.setPivot(PivotPosition.TopLeft);
        p.addGuiElement((GuiElement)this.lPz);
        this.tPz = new GuiTextField(0.71111107f, 0.8f, true, 0.16888888f, 0.05f, true);
        this.tPz.setPivot(PivotPosition.TopLeft);
        this.tPz.setFontColor(255);
        this.tPz.setListenForInput(true);
        this.tPz.setText(Float.toString(this.pz));
        p.addGuiElement((GuiElement)this.tPz);
        this.lFontD = new GuiLabel(0.12f, 0.7f, true);
        this.lFontD.setText("font");
        this.lFontD.setFontColor(-1);
        this.lFontD.setPivot(PivotPosition.TopLeft);
        p.addGuiElement((GuiElement)this.lFontD);
        this.lFont = new GuiLabel(0.21000001f, 0.71f, true);
        this.lFont.setPivot(PivotPosition.TopLeft);
        this.lFont.setFontColor(-1);
        this.lFont.setFontSize(40);
        this.lFont.setClickable(true);
        this.lFont.setText(this.sfonts[this.font]);
        p.addGuiElement((GuiElement)this.lFont);
        this.lFs = new GuiLabel(0.6f, 0.7f, true);
        this.lFs.setText("font size");
        this.lFs.setFontColor(-1);
        this.lFs.setPivot(PivotPosition.TopLeft);
        p.addGuiElement((GuiElement)this.lFs);
        this.tFs = new GuiTextField(0.69f, 0.72f, true, 0.19f, 0.05f, true);
        this.tFs.setPivot(PivotPosition.TopLeft);
        this.tFs.setFontColor(255);
        this.tFs.setListenForInput(true);
        this.tFs.setText(Integer.toString(this.fs));
        p.addGuiElement((GuiElement)this.tFs);
        this.lFg = new GuiLabel(0.26f, 0.62f, true);
        this.lFg.setPivot(PivotPosition.Center);
        this.lFg.setText("font color");
        this.lFg.setClickable(true);
        this.lFg.setFontColor(-1);
        this.pFg = new GuiPanel(0.26f, 0.62f, true, 0.28f, 0.05f, true);
        this.pFg.setPivot(PivotPosition.Center);
        this.pFg.setBorderColor(-1);
        this.pFg.setBorderThickness(0.015f, true);
        this.pFg.setColor(this.colors[this.fg]);
        this.pFg.setClickable(true);
        p.addGuiElement((GuiElement)this.pFg);
        this.lBg = new GuiLabel(0.74f, 0.62f, true);
        this.lBg.setPivot(PivotPosition.Center);
        this.lBg.setText("background color");
        this.lBg.setClickable(true);
        this.lBg.setFontColor(-1);
        this.pBg = new GuiPanel(0.74f, 0.62f, true, 0.28f, 0.05f, true);
        this.pBg.setPivot(PivotPosition.Center);
        this.pBg.setBorderColor(-1);
        this.pBg.setBorderThickness(0.015f, true);
        this.pBg.setColor(this.colors[this.bg]);
        this.pBg.setClickable(true);
        p.addGuiElement((GuiElement)this.pBg);
        p.addGuiElement((GuiElement)this.lBg);
        p.addGuiElement((GuiElement)this.lFg);
        this.lAW = new GuiLabel(0.12f, 0.54f, true);
        this.lAW.setPivot(PivotPosition.TopLeft);
        this.lAW.setText("allways visible(also through walls)");
        this.lAW.setFontColor(-1);
        p.addGuiElement((GuiElement)this.lAW);
        this.pAW = new GuiPanel(0.31f, 0.53f, true, 50.0f, 50.0f, false);
        this.pAW.setPivot(PivotPosition.Center);
        this.pAW.setBorderColor(-1);
        this.pAW.setBorderThickness(0.015f, true);
        this.pAW.setColor(this.aw ? -16776961 : -1);
        this.pAW.setClickable(true);
        p.addGuiElement((GuiElement)this.pAW);
        this.lBB = new GuiLabel(0.6f, 0.54f, true);
        this.lBB.setPivot(PivotPosition.TopLeft);
        this.lBB.setText("billboard(works like a sprite)");
        this.lBB.setFontColor(-1);
        p.addGuiElement((GuiElement)this.lBB);
        this.pBB = new GuiPanel(0.757f, 0.53f, true, 50.0f, 50.0f, false);
        this.pBB.setPivot(PivotPosition.Center);
        this.pBB.setBorderColor(-1);
        this.pBB.setBorderThickness(0.015f, true);
        this.pBB.setColor(this.bb ? -16776961 : -1);
        this.pBB.setClickable(true);
        p.addGuiElement((GuiElement)this.pBB);
        this.lRx = new GuiLabel(0.62f, 0.46f, true);
        this.lRx.setText("rotation x");
        this.lRx.setFontColor(-1);
        this.lRx.setPivot(PivotPosition.TopLeft);
        p.addGuiElement((GuiElement)this.lRx);
        this.tRx = new GuiTextField(0.7111111f, 0.48f, true, 0.16888888f, 0.05f, true);
        this.tRx.setPivot(PivotPosition.TopLeft);
        this.tRx.setFontColor(255);
        this.tRx.setListenForInput(true);
        this.tRx.setText(Float.toString(this.rx));
        this.tRx.setEditable(this.bb);
        p.addGuiElement((GuiElement)this.tRx);
        this.lRy = new GuiLabel(0.62f, 0.38f, true);
        this.lRy.setText("rotation y");
        this.lRy.setFontColor(-1);
        this.lRy.setPivot(PivotPosition.TopLeft);
        p.addGuiElement((GuiElement)this.lRy);
        this.tRy = new GuiTextField(0.7111111f, 0.4f, true, 0.16888888f, 0.05f, true);
        this.tRy.setPivot(PivotPosition.TopLeft);
        this.tRy.setFontColor(255);
        this.tRy.setListenForInput(true);
        this.tRy.setText(Float.toString(this.ry));
        this.tRy.setEditable(this.bb);
        p.addGuiElement((GuiElement)this.tRy);
        this.lRz = new GuiLabel(0.62f, 0.3f, true);
        this.lRz.setText("rotation z");
        this.lRz.setFontColor(-1);
        this.lRz.setPivot(PivotPosition.TopLeft);
        p.addGuiElement((GuiElement)this.lRz);
        this.tRz = new GuiTextField(0.7111111f, 0.32f, true, 0.16888888f, 0.05f, true);
        this.tRz.setPivot(PivotPosition.TopLeft);
        this.tRz.setFontColor(255);
        this.tRz.setListenForInput(true);
        this.tRz.setText(Float.toString(this.rz));
        this.tRz.setEditable(this.bb);
        p.addGuiElement((GuiElement)this.tRz);
        this.tRx.setEditable(!this.bb);
        this.tRy.setEditable(!this.bb);
        this.tRz.setEditable(!this.bb);
        this.tRx.setFontColor(this.bb ? -1717986817 : 255);
        this.tRy.setFontColor(this.bb ? -1717986817 : 255);
        this.tRz.setFontColor(this.bb ? -1717986817 : 255);
        this.lRx.setFontColor(this.bb ? -1717986817 : -1);
        this.lRy.setFontColor(this.bb ? -1717986817 : -1);
        this.lRz.setFontColor(this.bb ? -1717986817 : -1);
        this.bAdd = new GuiLabel(0.33f, 0.15f, true);
        this.bAdd.setPivot(PivotPosition.Center);
        this.bAdd.setText("EDIT");
        this.bAdd.setClickable(true);
        this.bAdd.setFontColor(-1);
        p.addGuiElement((GuiElement)this.bAdd);
        this.bCancel = new GuiLabel(0.66f, 0.15f, true);
        this.bCancel.setPivot(PivotPosition.Center);
        this.bCancel.setText("CANCEL");
        this.bCancel.setClickable(true);
        this.bCancel.setFontColor(-1);
        p.addGuiElement((GuiElement)this.bCancel);
    }

    @EventMethod
    public void onPlayerGuiElementClick(PlayerGuiElementClickEvent evt) {
        if (evt.getPlayer() == this.p) {
            if (evt.getGuiElement() == this.bAdd) {
                this.removeGui();
                World3DText text = new World3DText(this.txt);
                text.setPosition(this.px, this.py, this.pz);
                text.setFont(this.fonts[this.font]);
                text.setBackgroundColor(this.colors[this.bg]);
                text.setFontColor(this.colors[this.fg]);
                text.setFontsize(this.fs);
                text.setAlwaysVisible(this.aw);
                text.setBillboard(this.bb);
                text.setRotation(Utils.MathUtils.degreeToRadian((float)this.rx), Utils.MathUtils.degreeToRadian((float)this.ry), Utils.MathUtils.degreeToRadian((float)this.rz));
                this.plugin.removeAll();
                this.plugin.texts.set(this.id, text);
                this.plugin.reload();
            } else if (evt.getGuiElement() == this.bCancel) {
                this.removeGui();
            } else if (evt.getGuiElement() == this.lFont) {
                ++this.font;
                if (this.font >= this.fonts.length) {
                    this.font = 0;
                }
                this.lFont.setText(this.sfonts[this.font]);
            } else if (evt.getGuiElement() == this.pFg || evt.getGuiElement() == this.lFg) {
                ++this.fg;
                if (this.fg >= this.colors.length) {
                    this.fg = 0;
                }
                this.pFg.setColor(this.colors[this.fg]);
                this.p.removeGuiElement((GuiElement)this.lFg);
                this.p.addGuiElement((GuiElement)this.lFg);
            } else if (evt.getGuiElement() == this.pBg || evt.getGuiElement() == this.lBg) {
                ++this.bg;
                if (this.bg >= this.colors.length) {
                    this.bg = 0;
                }
                this.pBg.setColor(this.colors[this.bg]);
                this.p.removeGuiElement((GuiElement)this.lBg);
                this.p.addGuiElement((GuiElement)this.lBg);
            } else if (evt.getGuiElement() == this.pAW) {
                boolean bl = this.aw = !this.aw;
                if (this.aw) {
                    this.pAW.setColor(-16776961);
                } else {
                    this.pAW.setColor(-1);
                }
            } else if (evt.getGuiElement() == this.pBB) {
                boolean bl = this.bb = !this.bb;
                if (this.bb) {
                    this.pBB.setColor(-16776961);
                } else {
                    this.pBB.setColor(-1);
                }
                this.tRx.setEditable(!this.bb);
                this.tRy.setEditable(!this.bb);
                this.tRz.setEditable(!this.bb);
                this.tRx.setFontColor(this.bb ? -1717986817 : 255);
                this.tRy.setFontColor(this.bb ? -1717986817 : 255);
                this.tRz.setFontColor(this.bb ? -1717986817 : 255);
                this.lRx.setFontColor(this.bb ? -1717986817 : -1);
                this.lRy.setFontColor(this.bb ? -1717986817 : -1);
                this.lRz.setFontColor(this.bb ? -1717986817 : -1);
            }
        }
    }

    @EventMethod
    public void onPlayerGuiInput(PlayerGuiInputEvent evt) {
        if (evt.getPlayer() == this.p) {
            if (evt.getGuiElement() == this.tName) {
                this.txt = evt.getInput();
            } else if (evt.getGuiElement() == this.tPx) {
                if (!Utils.StringUtils.isNumeric((String)evt.getInput())) {
                    this.tPx.setText(Float.toString(this.px));
                } else {
                    this.px = Float.parseFloat(evt.getInput());
                }
            } else if (evt.getGuiElement() == this.tPy) {
                if (!Utils.StringUtils.isNumeric((String)evt.getInput())) {
                    this.tPy.setText(Float.toString(this.py));
                } else {
                    this.py = Float.parseFloat(evt.getInput());
                }
            } else if (evt.getGuiElement() == this.tPz) {
                if (!Utils.StringUtils.isNumeric((String)evt.getInput())) {
                    this.tPz.setText(Float.toString(this.pz));
                } else {
                    this.pz = Float.parseFloat(evt.getInput());
                }
            } else if (evt.getGuiElement() == this.tFs) {
                if (!Utils.StringUtils.isInteger((String)evt.getInput())) {
                    this.tFs.setText(Integer.toString(this.fs));
                } else {
                    this.fs = Integer.parseInt(evt.getInput());
                }
            } else if (evt.getGuiElement() == this.tRx) {
                if (!Utils.StringUtils.isNumeric((String)evt.getInput())) {
                    this.tRx.setText(Float.toString(this.rx));
                } else {
                    this.rx = Float.parseFloat(evt.getInput());
                }
            } else if (evt.getGuiElement() == this.tRy) {
                if (!Utils.StringUtils.isNumeric((String)evt.getInput())) {
                    this.tRy.setText(Float.toString(this.ry));
                } else {
                    this.ry = Float.parseFloat(evt.getInput());
                }
            } else if (evt.getGuiElement() == this.tRz) {
                if (!Utils.StringUtils.isNumeric((String)evt.getInput())) {
                    this.tRz.setText(Float.toString(this.rz));
                } else {
                    this.rz = Float.parseFloat(evt.getInput());
                }
            }
        }
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent evt) {
        if (evt.getPlayer() == this.p && evt.getKeyCode() == 1) {
            this.removeGui();
        }
    }

    private void removeGui() {
        this.plugin.unregisterEventListener(this);
        this.p.enableClientsideKeys(new int[]{1});
        this.p.setListenForKeyInput(false);
        this.p.setMouseCursorVisible(false);
        this.p.removeGuiElement((GuiElement)this.panel);
        this.p.removeGuiElement((GuiElement)this.bAdd);
        this.p.removeGuiElement((GuiElement)this.bCancel);
        this.p.removeGuiElement((GuiElement)this.tName);
        this.p.removeGuiElement((GuiElement)this.lPx);
        this.p.removeGuiElement((GuiElement)this.tPx);
        this.p.removeGuiElement((GuiElement)this.lPy);
        this.p.removeGuiElement((GuiElement)this.tPy);
        this.p.removeGuiElement((GuiElement)this.lPz);
        this.p.removeGuiElement((GuiElement)this.tPz);
        this.p.removeGuiElement((GuiElement)this.lFontD);
        this.p.removeGuiElement((GuiElement)this.lFont);
        this.p.removeGuiElement((GuiElement)this.lFs);
        this.p.removeGuiElement((GuiElement)this.tFs);
        this.p.removeGuiElement((GuiElement)this.lFg);
        this.p.removeGuiElement((GuiElement)this.pFg);
        this.p.removeGuiElement((GuiElement)this.lBg);
        this.p.removeGuiElement((GuiElement)this.pBg);
        this.p.removeGuiElement((GuiElement)this.lAW);
        this.p.removeGuiElement((GuiElement)this.pAW);
        this.p.removeGuiElement((GuiElement)this.lBB);
        this.p.removeGuiElement((GuiElement)this.pBB);
        this.p.removeGuiElement((GuiElement)this.lRx);
        this.p.removeGuiElement((GuiElement)this.tRx);
        this.p.removeGuiElement((GuiElement)this.lRy);
        this.p.removeGuiElement((GuiElement)this.tRy);
        this.p.removeGuiElement((GuiElement)this.lRz);
        this.p.removeGuiElement((GuiElement)this.tRz);
    }
}

