/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.text3d;

import de.galveston01.text3d.AddGui;
import de.galveston01.text3d.EditGui;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DText;
import net.risingworld.api.worldelements.WorldElement;

public class Text3D
extends Plugin
implements Listener {
    public ArrayList<World3DText> texts;

    public void onEnable() {
        this.texts = new ArrayList();
        this.registerEventListener(this);
        try {
            this.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent evt) {
        evt.getPlayer().registerKeys(new int[]{1});
        for (World3DText text : this.texts) {
            evt.getPlayer().addWorldElement((WorldElement)text);
        }
    }

    @EventMethod
    public void onPlayerComand(PlayerCommandEvent evt) {
        String command = evt.getCommand();
        String[] cmd = command.split(" ");
        if (cmd[0].equals("/t3d")) {
            if (!evt.getPlayer().isAdmin()) {
                evt.getPlayer().sendTextMessage("[#ff0000]ERROR! ONLY ADMINS ARE ALLOWED TO DO THIS!");
                return;
            }
            if (cmd.length == 2) {
                if (command.equals("/t3d help")) {
                    evt.getPlayer().sendTextMessage("[#ff0000]HELP");
                    evt.getPlayer().sendTextMessage("/t3d help");
                    evt.getPlayer().sendTextMessage("/t3d list");
                    evt.getPlayer().sendTextMessage("/t3d add");
                    evt.getPlayer().sendTextMessage("/t3d edit [#0000ff]id");
                    evt.getPlayer().sendTextMessage("/t3d rm [#0000ff]id");
                } else if (command.equals("/t3d list")) {
                    evt.getPlayer().sendTextMessage("[#ff0000]ALL 3D-Texts:");
                    int id = 0;
                    for (World3DText t : this.texts) {
                        Vector3f v = t.getPosition();
                        evt.getPlayer().sendTextMessage(id + ": " + t.getText() + " [#0000ff](" + v.x + ";" + v.y + ";" + v.z + ")");
                        ++id;
                    }
                } else if (command.equals("/t3d add")) {
                    AddGui ag = new AddGui(this, evt.getPlayer());
                    evt.getPlayer().setAttribute("AddGui", (Object)ag);
                } else if (command.equals("/t3d edit")) {
                    EditGui eg = new EditGui(this, evt.getPlayer(), this.texts.size() - 1);
                    evt.getPlayer().setAttribute("EditGui", (Object)eg);
                } else if (cmd[1].equals("rm")) {
                    if (cmd.length == 3 && Utils.StringUtils.isInteger((String)cmd[2])) {
                        int id = Integer.parseInt(cmd[2]);
                        if (id < this.texts.size()) {
                            this.removeAll();
                            this.texts.remove(id);
                            this.reload();
                            evt.getPlayer().sendTextMessage("removed text (" + id + ")");
                        } else {
                            evt.getPlayer().sendTextMessage("[#ff0000]ERROR! UNKNOWN ID!");
                        }
                    } else {
                        evt.getPlayer().sendTextMessage("[#ff0000]ERROR! YOU HAVE TO PASS AN ID!");
                    }
                } else if (cmd[1].equals("edit")) {
                    if (cmd.length == 3 && Utils.StringUtils.isInteger((String)cmd[2])) {
                        int id = Integer.parseInt(cmd[2]);
                        if (id < this.texts.size()) {
                            EditGui eg = new EditGui(this, evt.getPlayer(), id);
                            evt.getPlayer().setAttribute("EditGui", (Object)eg);
                        } else {
                            evt.getPlayer().sendTextMessage("[#ff0000]ERROR! UNKNOWN ID!");
                        }
                    } else {
                        evt.getPlayer().sendTextMessage("[#ff0000]ERROR! YOU HAVE TO PASS AN ID!");
                    }
                } else {
                    evt.getPlayer().sendTextMessage("[#ff0000]UNKNOWN TEXT3D COMMAND!");
                }
            } else {
                evt.getPlayer().sendTextMessage("[#ff0000]WRONG PARAMETERS COUNT FOR TEXT3D COMMAND!");
            }
        }
    }

    public void removeAll() {
        for (Player p : this.getServer().getAllPlayers()) {
            if (!this.getServer().isPlayerConnected(p.getName())) continue;
            for (World3DText text : this.texts) {
                p.removeWorldElement((WorldElement)text);
            }
        }
    }

    public void reload() {
        try {
            this.write();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.texts = new ArrayList();
        try {
            this.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void write() throws IOException {
        File f = new File(this.getPath() + "/" + this.getWorld().getName() + ".list");
        if (!f.exists()) {
            f.createNewFile();
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        for (World3DText t : this.texts) {
            bw.write(t.getText() + "\n");
            float[] r = t.getRotation().toAngles();
            bw.write(t.getPosition().x + " " + t.getPosition().y + " " + t.getPosition().z + " " + r[0] + " " + r[1] + " " + r[2] + "\n");
            bw.write(t.getBackgroundColor() + " " + t.getFontColor() + " " + t.getFontsize() + " " + t.getFont().name() + " " + t.isAlwaysVisible() + " " + t.isBillboard() + "\n");
        }
        bw.close();
    }

    public void read() throws IOException {
        File f = new File(this.getPath() + "/" + this.getWorld().getName() + ".list");
        if (f.exists()) {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String txt = "";
            while ((txt = br.readLine()) != null) {
                String l1 = br.readLine();
                String l2 = br.readLine();
                if (l1 == null || l2 == null) continue;
                String[] spos = l1.split(" ");
                String[] props = l2.split(" ");
                if (spos.length != 6 || !Utils.StringUtils.isNumeric((String)spos[0]) || !Utils.StringUtils.isNumeric((String)spos[1]) || !Utils.StringUtils.isNumeric((String)spos[2]) || !Utils.StringUtils.isNumeric((String)spos[3]) || !Utils.StringUtils.isNumeric((String)spos[4]) || !Utils.StringUtils.isNumeric((String)spos[5]) || props.length != 6 || !Utils.StringUtils.isInteger((String)props[0]) || !Utils.StringUtils.isInteger((String)props[1]) || !Utils.StringUtils.isInteger((String)props[2]) || !Utils.StringUtils.isBoolean((String)props[4]) || !Utils.StringUtils.isBoolean((String)props[5])) continue;
                float px = Float.parseFloat(spos[0]);
                float py = Float.parseFloat(spos[1]);
                float pz = Float.parseFloat(spos[2]);
                float rx = Float.parseFloat(spos[3]);
                float ry = Float.parseFloat(spos[4]);
                float rz = Float.parseFloat(spos[5]);
                int bg = Integer.parseInt(props[0]);
                int fg = Integer.parseInt(props[1]);
                int fs = Integer.parseInt(props[2]);
                Font font = Font.valueOf((String)props[3]);
                boolean aw = Boolean.parseBoolean(props[4]);
                boolean bb = Boolean.parseBoolean(props[5]);
                World3DText text = new World3DText(txt);
                text.setPosition(px, py, pz);
                text.setRotation(rx, ry, rz);
                text.setBackgroundColor(bg);
                text.setFontColor(fg);
                text.setFontsize(fs);
                text.setFont(font);
                text.setAlwaysVisible(aw);
                text.setBillboard(bb);
                this.texts.add(text);
            }
            br.close();
        }
        for (Player p : this.getServer().getAllPlayers()) {
            if (!this.getServer().isPlayerConnected(p.getName())) continue;
            for (World3DText text : this.texts) {
                p.addWorldElement((WorldElement)text);
            }
        }
    }
}

