package com.vistamaresoft.test;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;

public class Test extends Plugin implements Listener
{
	// attribute keys
	public static final String		key_status	= "com.vms.labelStatus";
	public static final	int			hasLabelA	= 1;
	public static final	int			hasLabelB	= 2;

	// FIELDS
	private	GuiLabel	labelA;
	private	GuiLabel	labelB;

	@Override
	public void onEnable()
	{
		labelA	= new GuiLabel("Label A", 20, 100, false);
		labelB	= new GuiLabel("Label B", 20, 120, false);
		registerEventListener(this);
	}

	@Override
	public void onDisable()
	{
		unregisterEventListener(this);
		labelA	= null;
		labelB	= null;
	}

	@EventMethod
	public void onPlayerConnect(PlayerConnectEvent event)
	{
		event.getPlayer().setAttribute(key_status, 0);
	}

	@EventMethod
	public void onPlayerCommand(PlayerCommandEvent event)
	{
		Player		player	= event.getPlayer();
		String[]	cmd		= event.getCommand().split(" ");

		if (cmd[0].equals("/testadd") )
		{
			player.addGuiElement(labelA);
			player.addGuiElement(labelB);
			player.setAttribute(key_status, hasLabelA + hasLabelB);
		}
		else if (cmd[0].equals("/testremovea") )
		{
			int		hasLabel	= (int)player.getAttribute(key_status);
			if ( (hasLabel & hasLabelA) != 0)
				labelA.destroy();
			hasLabel |= ~hasLabelA;
			player.setAttribute(key_status, hasLabel);
		}
		else if (cmd[0].equals("/testremoveb") )
		{
			int		hasLabel	= (int)player.getAttribute(key_status);
			if ( (hasLabel & hasLabelB) != 0)
				labelB.destroy();
			hasLabel |= ~hasLabelB;
			player.setAttribute(key_status, hasLabel);
		}
	}

}
