/*
 * Decompiled with CFR 0.152.
 */
package eu.hessenstrolche.willkommen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class Willkommen
extends Plugin
implements Listener {
    private String welcomeMessage = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnable() {
        File file = new File(this.getPath() + "/assets/test.txt");
        if (file.exists()) {
            BufferedReader br = null;
            try {
                String line = "";
                br = new BufferedReader(new FileReader(file));
                try {
                    while ((line = br.readLine()) != null) {
                        this.welcomeMessage = this.welcomeMessage + line;
                    }
                }
                catch (IOException ex) {
                    System.out.println("Fehler: " + ex);
                }
            }
            catch (FileNotFoundException ex) {
                System.out.println("Fehler: " + ex);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    System.out.println("Fehler: " + ex);
                }
            }
        }
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        GuiPanel panel = new GuiPanel(0.5f, 0.75f, true, 999.0f, 50.0f, false);
        panel.setPivot(PivotPosition.Center);
        panel.setColor(187);
        player.addGuiElement((GuiElement)panel);
        player.setAttribute("welcomePanel", (Object)panel);
        GuiLabel label = new GuiLabel(0.5f, 0.5f, true);
        label.setPivot(PivotPosition.Center);
        label.setVisible(true);
        panel.addChild((GuiElement)label);
        player.addGuiElement((GuiElement)label);
        player.setAttribute("welcomeLabel", (Object)label);
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        Player player = event.getPlayer();
        if (!this.welcomeMessage.isEmpty()) {
            GuiPanel panel = (GuiPanel)player.getAttribute("welcomePanel");
            GuiLabel label = (GuiLabel)player.getAttribute("welcomeLabel");
            label.setText(this.welcomeMessage.toUpperCase());
            panel.setVisible(true);
            Timer showTimer = new Timer(0.0f, 30.0f, 0, () -> panel.setVisible(false));
            showTimer.start();
        }
    }
}

