world = getWorld();

function onEnable()
    print("World Edit plugin loaded.");
end

function onPlayerCommand(event)
	local cmd = StringUtils:explode(event.command, " ");
	
	if #cmd >= 1 then
		cmd[1] = string.lower(cmd[1]);

		if cmd[1] == "/we-select" then
			event.player:enableMarkingSelector(function()
				
			end);

		elseif cmd[1] == "/we-cancel" then
			event.player:disableMarkingSelector(function(markingEvent)

			end);

		elseif cmd[1] == "/we-clear" then
			if event.player:isAdmin() == false then
				event.player:sendTextMessage("[#FF0000]You don't have admin rights on this server. Request Admin rights or use /we-cancel to cancel the selection.");
				return;
			end
			if #cmd >= 2 then
				event.player:disableMarkingSelector(function(markingEvent)
					if markingEvent ~= false then
						coords = getCoordsFromMarkEvent(markingEvent);
						
						if cmd[2] == "obj" then
							removeObjects(coords);
						elseif cmd[2] == "con" then
							removeConstr(coords);
						elseif cmd[2] == "veg" then
							removeVeg(coords);
						elseif cmd[2] == "all" then
							removeObjects(coords);
							removeConstr(coords);
							removeVeg(coords);
						else
							event.player:sendTextMessage("[#FF0000]Use one of the following arguments:\nobj\ncon\nveg\nall");
							markingEvent:setCancel(true);
						end
						event.player:sendTextMessage("[#00FF00]Selection successfully cleared!");
					else
						event.player:sendTextMessage("[#FF0000]No selection");
					end
				end);
			else
				event.player:sendTextMessage("[#FF0000]Use one of the following arguments:\nobj\ncon\nveg\nall");
			end
		elseif cmd[1] == "/we-fill" then
			if event.player:isAdmin() == false then
				event.player:sendTextMessage("[#FF0000]You don't have admin rights on this server. Request Admin rights or use /we-cancel to cancel the selection.");
				return;
			end
			if #cmd >= 2 then
				event.player:disableMarkingSelector(function(markingEvent)
					if markingEvent ~= false then
						coords = getCoordsFromMarkEvent(markingEvent);

						if cmd[2] == "air" then
							fillWith(coords,0);
						elseif cmd[2] == "dirt" then
							fillWith(coords,1);
						elseif cmd[2] == "stone" then
							fillWith(coords,3);
						elseif cmd[2] == "id" then
							if #cmd >= 3 then
								if tonumber(cmd[3]) ~= nil then
									fillWith(coords, cmd[3]);
									-- markingEvent:setCancel(true);
								else
									event.player:sendTextMessage("[#FF0000]3rd argument is not a number!");
									markingEvent:setCancel(true);
								end
							else
								event.player:sendTextMessage("[#FF0000]Missing 3rd argument: id");
								markingEvent:setCancel(true);
							end
						else
							event.player:sendTextMessage("[#FF0000]Use one of the following arguments:\nair\ndirt\nstone\nid #id#");
							markingEvent:setCancel(true);
						end
					else
						event.player:sendTextMessage("[#FF0000]No selection");
					end
				end);

			else
				event.player:sendTextMessage("[#FF0000]Use one of the following arguments:\nair\ndirt\nstone");
			end
		end
	end
end
addEvent("PlayerCommand", onPlayerCommand);

function getCoordsFromMarkEvent(e)
	if e ~= false then
		c = {}
		c[1] = e.startChunkpositionX;
		c[2] = e.startChunkpositionY;
		c[3] = e.startChunkpositionZ;
		
		c[4] = e.startBlockpositionX;
		c[5] = e.startBlockpositionY;
		c[6] = e.startBlockpositionZ;
		
		c[7] = e.endChunkpositionX;
		c[8] = e.endChunkpositionY;
		c[9] = e.endChunkpositionZ;
		
		c[10] = e.endBlockpositionX;
		c[11] = e.endBlockpositionY;
		c[12] = e.endBlockpositionZ;
	end

	return c;
end

function removeObjects(c)
	world:removeAllObjectsInArea(c[1],c[2],c[3],c[4],c[5],c[6],c[7],c[8],c[9],c[10],c[11],c[12]);
end

function removeConstr(c)
	world:removeAllConstructionsInArea(c[1],c[2],c[3],c[4],c[5],c[6],c[7],c[8],c[9],c[10],c[11],c[12]);
end

function removeVeg(c)
	world:removeAllVegetationsInArea(c[1],c[2],c[3],c[4],c[5],c[6],c[7],c[8],c[9],c[10],c[11],c[12]);
end

function fillWith(c, blockID)
	removeObjects(c);
	removeConstr(c);
	removeVeg(c);
	-- print("trying to set block data to 0");
	world:setBlockDataInArea(c[1],c[2],c[3],c[4],c[5],c[6],c[7],c[8],c[9],c[10],c[11],c[12], 0);
	-- print("trying to set terrain data");
	world:setTerrainDataInArea(c[1],c[2],c[3],c[4],c[5],c[6],c[7],c[8],c[9],c[10],c[11],c[12], blockID);
	
end