/****************************
	G u i T e s t  -  A Rising World Java plug-in to test GUI elements

	GuiTest.java - The main plug-in class

	Created by : Maurizio M. Gavioli 2016-10-21

	(C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
	Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)

*****************************/

package com.vistamaresoft.guitest;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.objects.Player;

public class GuiTest extends Plugin implements Listener
{
	public static final	String	commandPrefix	= "/test";
	public static final double	version			= 0.1;
	public static final String	msg_deinit		= "GuiTest "+version+" unloaded successfully!";
	public static final String	msg_init		= "GuiTest "+version+" loaded successfully!";
	// attribute keys
	public static final String	key_gui			= "guitestGUI";

/*
	public GuiTest()
	{
	}
*/
	@Override
	public void onEnable()
	{
		System.out.println(msg_init);
		registerEventListener(this);
	}

	@Override
	public void onDisable()
	{
		unregisterEventListener(this);
		System.out.println(msg_deinit);
	}

	/** Called by Rising World when the player spawns into a world after having connected.

		@param	event	the spawn event
	 */
	@EventMethod
	public void onPlayerSpawn(PlayerSpawnEvent event)
	{
		Player		player	= event.getPlayer();
		// the GUI panel
		Gui	gui	= new Gui(player);
		player.addGuiElement(gui);
		player.setAttribute(key_gui, gui);
	}

	/**	Called when the player issues a command ("/...") in the chat window

		@param event	the command event
	*/
	@EventMethod
	public void onPlayerCommand(PlayerCommandEvent event)
	{
		Player		player	= event.getPlayer();
		String[]	cmd		= event.getCommand().split(" ");

		if (cmd[0].equals(commandPrefix) )
		{
			switch(cmd.length)
			{
			case 1:
	//			// if no sub-command, flip text display on/off
	//			setGPSShow(player, !(boolean)player.getAttribute(key_gpsShow));
				// if no sub-command, show the GPS GUI panel
				Gui	gui	= (Gui)player.getAttribute(key_gui);
				if (gui != null)
					gui.show(player);
				return;
			}
		}
	}

	/**
		Called when the player clicks on the GUI
		@param	player	the player who clicked the GUI
	*/
	@EventMethod
	public void onPlayerClick(PlayerGuiElementClickEvent event)
	{
		Player	player	= event.getPlayer();
		Gui		gui		= (Gui)player.getAttribute(key_gui);
		if (gui != null)
			gui.click(event.getGuiElement(), player);
	}

}
