/****************************
	G u i T e s t  -  A Rising World Java plug-in to test GUI elements

	Gui.java - The GUI panel class

	Created by : Maurizio M. Gavioli 2016-10-21

	(C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
	Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)

*****************************/

package com.vistamaresoft.guitest;

import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class Gui extends GuiPanel
{
	// CONSTANTS
	//
	// The position (relative to screen size) and size (absolute) of the GUI panel
	// Position is centred in the screen
	// Size is conventional.
	private static final	float	PANEL_XPOS		= 0.5f;
	private static final	float	PANEL_YPOS		= 0.5f;
	private static final	int		PANEL_WIDTH		= 400;
	private static final	int		PANEL_HEIGHT	= 200;
	private static final	int		PANEL_COLOUR	= 0x20202080;
	private static final	int		BORDER_COLOUR	= 0x000000FF;
	private static final	int		BORDER_THICKNESS= 2;

	// some border values
	private static final	int		BUTTON_COLOUR	= 0x0000C0FF;
	private static final	int		BUTTON_INACTIVE	= 0x803030FF;
	private static final	int		BUTTON_SIZE		= 18;
	private static final	int		BORDER			= 6;

	// sizes and positions of the various elements of the panel
	private static final	int		BOX_X_STEP		= (PANEL_WIDTH / 4);
	private static final	int		BOX_YPOS		= (PANEL_HEIGHT * 2 / 3);
	private static final	int		NUM_OF_BOXES	= 3;

	private static final	int		BUTT_X_STEP		= (PANEL_WIDTH / 3);
	private static final	int		BUTT_YPOS		= (PANEL_HEIGHT * 1 / 3);

	private static final	int		CLOSE_XPOS		= (PANEL_WIDTH / 2);
	private static final	int		CLOSE_YPOS		= (BUTTON_SIZE + BORDER);

	// Texts
	static final public String[]	txt_box			= { "111\n111\n111", "222\n222\n222", "333\n333\n333" };
	static final public String		txt_close		= "CLOSE";
	static final public String		txt_next		= "\u00a0>\u00a0";
	static final public String		txt_prev		= "\u00a0<\u00a0";

	// FIELDS
	//
	private GuiLabel		buttonClose;	// the "CLOSE" button
	private GuiLabel[]		boxes;			// the 3 boxes
	private	GuiLabel		buttonNext;		// the "next box" button
	private	GuiLabel		buttonPrev;		// the "prev box" button
	private int				currBox;		// the currently active box

	public Gui(Player player)
	{
		// create a panel
		super(PANEL_XPOS, PANEL_YPOS, true, PANEL_WIDTH, PANEL_HEIGHT, false);
		setPivot(PivotPosition.Center);
		setBorderColor(BORDER_COLOUR);
		setBorderThickness(BORDER_THICKNESS, false);
		setColor(PANEL_COLOUR);
		setVisible(false);
		currBox				= 0;

		// PREV & NEXT buttons
		buttonPrev	= new GuiLabel(BUTT_X_STEP, BUTT_YPOS, false);
		buttonPrev.setPivot(PivotPosition.Center);
		buttonPrev.setColor(BUTTON_INACTIVE);
		buttonPrev.setFontSize(BUTTON_SIZE);
		buttonPrev.setClickable(false);
		buttonPrev.setText(txt_prev);
		addChild(buttonPrev);
		player.addGuiElement(buttonPrev);

		buttonNext	= new GuiLabel(BUTT_X_STEP * 2, BUTT_YPOS, false);
		buttonNext.setPivot(PivotPosition.Center);
		buttonNext.setColor(BUTTON_COLOUR);
		buttonNext.setFontSize(BUTTON_SIZE);
		buttonNext.setClickable(true);
		buttonNext.setText(txt_next);
		addChild(buttonNext);
		player.addGuiElement(buttonNext);

		// The 3 boxes
		boxes	= new GuiLabel[3];
		for (int i = 0; i < NUM_OF_BOXES; i++)
		{
			boxes[i] = new GuiLabel(BOX_X_STEP * (i+1), BOX_YPOS, false);
			boxes[i].setPivot(PivotPosition.Center);
			boxes[i].setColor(i == 0 ? BUTTON_COLOUR : BUTTON_INACTIVE);
			boxes[i].setFontSize(BUTTON_SIZE);
			boxes[i].setClickable(i == 0 ? true : false);
			boxes[i].setText(txt_box[i]);
			addChild(boxes[i]);
			player.addGuiElement(boxes[i]);
		}

		// CLOSE button
		buttonClose	= new GuiLabel(CLOSE_XPOS, CLOSE_YPOS, false);
		buttonClose.setPivot(PivotPosition.Center);
		buttonClose.setColor(BUTTON_COLOUR);
		buttonClose.setFontSize(BUTTON_SIZE);
		buttonClose.setClickable(true);
		buttonClose.setText(txt_close);
		addChild(buttonClose);
		player.addGuiElement(buttonClose);
	}

	/**
		Process a mouse click on the child GUI element @a element. 

		@param	element	the element which has been clicked
		@param	player	the player this panel refers to
	*/
	public void click(GuiElement element, Player player)
	{
		if (element == buttonPrev)
		{
			if (currBox > 0)
				currBox--;
		}
		else if (element == buttonNext)
		{
			if (currBox < NUM_OF_BOXES)
				currBox++;
		}
		else if (element == boxes[0])
			player.sendTextMessage("You clicked box 1");
		else if (element == boxes[1])
			player.sendTextMessage("You clicked box 2");
		else if (element == boxes[2])
			player.sendTextMessage("You clicked box 3");
		else if (element == buttonClose)
		{
			player.setMouseCursorVisible(false);
			setVisible(false);
		}
		else
			return;
		updateControls(player);
	}

	/**
		Shows the GUI panel for the Player @a player.
		The panel is filled with appropriate texts and made visible.
		Attaching it to the proper player should be managed by the caller.

		@param player	the player to which this panel refers to
	*/
	public void show(Player player)
	{
		player.setMouseCursorVisible(true);
		updateControls(player);
		setVisible(true);
	}

	private void updateControls(Player player)
	{
		// enable/disable PREV/NEXT buttons according to current box index
		// The PREV button is removed from the player GUI before the change
		// and re-added after: it works correctly. The other do not.
		player.removeGuiElement(buttonPrev);
		buttonPrev.setColor(currBox > 0 ? BUTTON_COLOUR : BUTTON_INACTIVE);
		buttonPrev.setClickable(currBox > 0 ? true : false);
		player.addGuiElement(buttonPrev);

		buttonNext.setColor(currBox < NUM_OF_BOXES-1 ? BUTTON_COLOUR : BUTTON_INACTIVE);
		buttonNext.setClickable(currBox < NUM_OF_BOXES-1 ? true : false);

		// check the changes in the internal values for colour and position
		int		colour0		= boxes[0].getColor();			// colour and x position before change
		int		colour1		= boxes[1].getColor();
		float	x0			= boxes[0].getPositionX();
		float	x1			= boxes[1].getPositionX();

		// set colour and 'clickability' of each box
		for (int i = 0; i < NUM_OF_BOXES; i++)
		{
//			boxes[i].setColor(i == currBox ? BUTTON_COLOUR : BUTTON_INACTIVE);
			colour0				= boxes[0].getColor();		// check change in colour and position
			colour1				= boxes[1].getColor();
			x0					= boxes[0].getPositionX();
			x1					= boxes[1].getPositionX();
			boxes[i].setClickable(i == currBox ? true : false);
			colour0				= boxes[0].getColor();
			colour1				= boxes[1].getColor();
			x0					= boxes[0].getPositionX();
			x1					= boxes[1].getPositionX();
		}
	}

}
