/*
 * Decompiled with CFR 0.152.
 */
package de.staticmodels;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class StaticModels
extends Plugin
implements Listener {
    public ArrayList<World3DModel> models = new ArrayList();

    public void onEnable() {
        for (File f : new File(this.getPath()).listFiles()) {
            if (!f.getName().endsWith(".model")) continue;
            String smodel = null;
            String stexture = null;
            float px = 0.0f;
            float py = 0.0f;
            float pz = 0.0f;
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            float scale = 1.0f;
            try {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String line = "";
                while ((line = br.readLine()) != null) {
                    String[] sp = line.split(":");
                    if (sp.length != 2) continue;
                    switch (sp[0]) {
                        case "model": {
                            smodel = sp[1];
                            break;
                        }
                        case "texture": {
                            stexture = sp[1];
                            break;
                        }
                        case "scale": {
                            scale = Float.parseFloat(sp[1]);
                            break;
                        }
                        case "px": {
                            px = Float.parseFloat(sp[1]);
                            break;
                        }
                        case "py": {
                            py = Float.parseFloat(sp[1]);
                            break;
                        }
                        case "pz": {
                            pz = Float.parseFloat(sp[1]);
                            break;
                        }
                        case "rx": {
                            rx = Float.parseFloat(sp[1]);
                            break;
                        }
                        case "ry": {
                            ry = Float.parseFloat(sp[1]);
                            break;
                        }
                        case "rz": {
                            rz = Float.parseFloat(sp[1]);
                        }
                    }
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (smodel == null || stexture == null) {
                return;
            }
            if (!new File(this.getPath() + "/" + smodel).exists() || !new File(this.getPath() + "/" + stexture).exists()) {
                return;
            }
            try {
                ModelInformation model = new ModelInformation(this.getPath() + "/" + smodel);
                ImageInformation texture = new ImageInformation(this.getPath() + "/" + stexture);
                World3DModel model3d = new World3DModel(model, texture);
                model3d.setLightingEnabled(true);
                model3d.setCollisionShape(CollisionShape.createHullCollisionShape());
                model3d.setPosition(px, py, pz);
                model3d.setRotation(rx, ry, rz);
                model3d.setScale(scale);
                this.models.add(model3d);
                for (Player player : this.getServer().getAllPlayers()) {
                    if (!this.getServer().isPlayerConnected(player.getName())) continue;
                    player.addWorldElement((WorldElement)model3d);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onDisable() {
    }

    @EventMethod(value=Threading.Sync)
    public void onPlayerConnect(PlayerConnectEvent evt) {
        Player p = evt.getPlayer();
        for (World3DModel model : this.models) {
            p.addWorldElement((WorldElement)model);
        }
    }
}

