/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.guestbook;

import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerElementInteractionEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.example.guestbook.Guestbook;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class PlayerListener
implements Listener {
    private Guestbook plugin;

    public PlayerListener(Guestbook plugin) {
        this.plugin = plugin;
    }

    @EventMethod(value=Threading.Sync)
    public void onPlayerConnect(PlayerConnectEvent evt) {
        Player p = evt.getPlayer();
        if (evt.isNewPlayer()) {
            this.plugin.addNewEntry(p.getName(), p.getLastTimeOnline());
        }
        this.initGuiForPlayer(p);
        for (World3DModel model : this.plugin.guestbookModels) {
            p.addWorldElement((WorldElement)model);
        }
        p.registerKeys(new int[]{1});
        p.setListenForKeyInput(true);
    }

    @EventMethod
    public void onPlayerGuiClick(PlayerGuiElementClickEvent evt) {
        Player p = evt.getPlayer();
        GuiElement element = evt.getGuiElement();
        GuiLabel guestbookPrevious = (GuiLabel)p.getAttribute("gb_previous");
        GuiLabel guestbookNext = (GuiLabel)p.getAttribute("gb_next");
        if (element == guestbookNext) {
            int page = (Integer)p.getAttribute("gb_page");
            GuiLabel[] guestbookLabels = (GuiLabel[])p.getAttribute("gb_labels");
            int maxpage = this.plugin.entries.size() / guestbookLabels.length;
            if (++page > maxpage) {
                page = maxpage;
            }
            this.setPageForPlayer(p, page);
            p.playGameSound("gui_journal_changepage");
        } else if (element == guestbookPrevious) {
            int page = (Integer)p.getAttribute("gb_page");
            if (--page < 0) {
                page = 0;
            }
            this.setPageForPlayer(p, page);
            p.playGameSound("gui_journal_changepage");
        }
    }

    @EventMethod
    public void onPlayerInteract(PlayerElementInteractionEvent evt) {
        Player p = evt.getPlayer();
        WorldElement element = evt.getWorldElement();
        for (World3DModel model : this.plugin.guestbookModels) {
            if (model != element) continue;
            int page = (Integer)p.getAttribute("gb_page");
            GuiLabel[] guestbookLabels = (GuiLabel[])p.getAttribute("gb_labels");
            int maxpage = this.plugin.entries.size() / guestbookLabels.length;
            if (page > maxpage) {
                page = maxpage;
            }
            this.setPageForPlayer(p, page);
            p.playGameSound("gui_journal_show");
            p.setMouseCursorVisible(true);
            GuiImage guestbookBackground = (GuiImage)p.getAttribute("gb_background");
            guestbookBackground.setVisible(true);
            p.disableClientsideKeys(new int[]{1});
            break;
        }
    }

    @EventMethod
    public void onPlayerKeyInput(PlayerKeyEvent evt) {
        GuiImage guestbookBackground;
        Player p = evt.getPlayer();
        if (evt.isPressed() && evt.getKeyCode() == 1 && (guestbookBackground = (GuiImage)p.getAttribute("gb_background")).isVisible()) {
            guestbookBackground.setVisible(false);
            p.enableClientsideKeys(new int[]{1});
            p.setMouseCursorVisible(false);
        }
    }

    private void initGuiForPlayer(Player p) {
        GuiLabel label;
        int i;
        GuiImage guestbookBackground = new GuiImage(this.plugin.guestbookTexture, 0.5f, 0.5f, true, 500.0f, 500.0f, false);
        p.setAttribute("gb_background", (Object)guestbookBackground);
        guestbookBackground.setPivot(PivotPosition.Center);
        guestbookBackground.setWidthProportional(1000.0f, false);
        guestbookBackground.setVisible(false);
        p.addGuiElement((GuiElement)guestbookBackground);
        GuiLabel guestbookPrevious = new GuiLabel("<- Previous", 0.15f, 0.2f, true);
        guestbookPrevious.setFont(Font.Handdrawn);
        guestbookPrevious.setFontColor(255);
        guestbookPrevious.setFontSize(34);
        guestbookPrevious.setClickable(true);
        guestbookBackground.addChild((GuiElement)guestbookPrevious);
        p.setAttribute("gb_previous", (Object)guestbookPrevious);
        p.addGuiElement((GuiElement)guestbookPrevious);
        GuiLabel guestbookNext = new GuiLabel("Next ->", 0.85f, 0.2f, true);
        guestbookNext.setPivot(PivotPosition.BottomRight);
        guestbookNext.setFont(Font.Handdrawn);
        guestbookNext.setFontColor(255);
        guestbookNext.setFontSize(34);
        guestbookNext.setClickable(true);
        guestbookBackground.addChild((GuiElement)guestbookNext);
        p.setAttribute("gb_next", (Object)guestbookNext);
        p.addGuiElement((GuiElement)guestbookNext);
        GuiLabel[] guestbookLabels = new GuiLabel[18];
        for (i = 0; i < 9; ++i) {
            label = new GuiLabel(0.12f, 0.775f - (float)i * 0.065f, true);
            label.setFont(Font.Handdrawn);
            label.setFontColor(255);
            label.setFontSize(30);
            label.setColorCodesEnabled(true);
            guestbookBackground.addChild((GuiElement)label);
            guestbookLabels[i] = label;
            p.addGuiElement((GuiElement)label);
        }
        for (i = 0; i < 9; ++i) {
            label = new GuiLabel(0.55f, 0.775f - (float)i * 0.065f, true);
            label.setFont(Font.Handdrawn);
            label.setFontColor(255);
            label.setFontSize(30);
            label.setColorCodesEnabled(true);
            guestbookBackground.addChild((GuiElement)label);
            guestbookLabels[i + 9] = label;
            p.addGuiElement((GuiElement)label);
        }
        p.setAttribute("gb_labels", (Object)guestbookLabels);
        p.setAttribute("gb_page", (Object)0);
    }

    private void setPageForPlayer(Player player, int page) {
        player.setAttribute("gb_page", (Object)page);
        GuiLabel[] guestbookLabels = (GuiLabel[])player.getAttribute("gb_labels");
        for (int i = 0; i < guestbookLabels.length && i < this.plugin.entries.size(); ++i) {
            int index = page * guestbookLabels.length + i;
            if (index < this.plugin.entries.size()) {
                String entry = this.plugin.entries.get(index);
                guestbookLabels[i].setText(index + ". " + entry);
                continue;
            }
            guestbookLabels[i].setText("");
        }
    }
}

