/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.guestbook;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.example.guestbook.PlayerListener;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.World3DModel;

public class Guestbook
extends Plugin {
    public ArrayList<World3DModel> guestbookModels = new ArrayList();
    public ImageInformation guestbookTexture;
    public ArrayList<String> entries = new ArrayList();

    public void onEnable() {
        this.initializeGUI();
        this.initializeModel();
        this.loadEntriesFromDatabase();
        this.registerEventListener(new PlayerListener(this));
        System.out.println("Guestbook plugin loaded successfully!");
    }

    public void onDisable() {
    }

    private void initializeGUI() {
        try {
            this.guestbookTexture = new ImageInformation(this.getPath() + "/assets/guestbook_background.dds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeModel() {
        try {
            String content;
            ModelInformation model = new ModelInformation(this.getPath() + "/assets/guestbook.obj");
            ImageInformation texture = new ImageInformation(this.getPath() + "/assets/guestbook.dds");
            File coordinates = new File(this.getPath() + "/coordinates.txt");
            if (coordinates.exists() && (content = Utils.FileUtils.readStringFromFile((File)coordinates)) != null && !content.isEmpty()) {
                String[] lines;
                for (String line : lines = content.split("\r\n|\n|\r")) {
                    String[] values;
                    int eol;
                    if (!line.matches("\\[([-0-9\\.]+(, |(\\](.)*)$){1}){6}(.)*") || (eol = line.indexOf(93)) <= 0 || (values = line.substring(1, eol).split(", ")).length != 6) continue;
                    World3DModel guestbookModel = this.create3DModel(model, texture);
                    if (Utils.StringUtils.isNumeric((String)values[0]) && Utils.StringUtils.isNumeric((String)values[1]) && Utils.StringUtils.isNumeric((String)values[2])) {
                        float x = Float.parseFloat(values[0]);
                        float y = Float.parseFloat(values[1]);
                        float z = Float.parseFloat(values[2]);
                        guestbookModel.setPosition(x, y, z);
                    }
                    if (Utils.StringUtils.isNumeric((String)values[3]) && Utils.StringUtils.isNumeric((String)values[4]) && Utils.StringUtils.isNumeric((String)values[5])) {
                        float rx = Utils.MathUtils.degreeToRadian((float)Float.parseFloat(values[3]));
                        float ry = Utils.MathUtils.degreeToRadian((float)Float.parseFloat(values[4]));
                        float rz = Utils.MathUtils.degreeToRadian((float)Float.parseFloat(values[5]));
                        guestbookModel.setRotation(rx, ry, rz);
                    }
                    this.guestbookModels.add(guestbookModel);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private World3DModel create3DModel(ModelInformation model, ImageInformation texture) {
        World3DModel guestbookModel = new World3DModel(model, texture);
        guestbookModel.setLightingEnabled(true);
        guestbookModel.setInteractable(true);
        guestbookModel.setInteractionCrosshair(Crosshair.Write);
        guestbookModel.setCollisionShape(CollisionShape.createHullCollisionShape());
        guestbookModel.setScale(0.0085f);
        return guestbookModel;
    }

    private void loadEntriesFromDatabase() {
        WorldDatabase database = this.getWorldDatabase();
        try (ResultSet result = database.executeQuery("SELECT * FROM `Player`");){
            while (result.next()) {
                String playername = result.getString("Name");
                long date = result.getLong("LastTimeOnline");
                this.addNewEntry(playername, date);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addNewEntry(String playername, long date) {
        this.entries.add(playername + "\n Last visit: " + Utils.GeneralUtils.getFormattedTimeAndDate((long)date));
    }
}

