package net.risingworld.api.example.ts;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Player;

/**
 * This is our main plugin class. It has to extend "Plugin", and implement the
 * methods "onEnable()" (which is called when the plugin is loaded) and
 * "onDisable()" (which is called when the plugin is unloaded).
 * Since this is just a small plugin, we don't want to create a separate event
 * listener, so we just declared this class as our event listener (by adding
 * "implements Listener", i.e. this plugin implements the Listener interface).
 * 
 * @author red51
 */

public class ConnectTS extends Plugin implements Listener{

    @Override
    public void onEnable(){
        //Our plugin main class is also our event listener (it implements the
        //"Listener" interface), so we have to register it accordingly:
        registerEventListener(this);
    }

    @Override
    public void onDisable(){
        //Nothing we want to do when the plugin gets unloaded, so we just 
        //keep this method blank...
    }
    
    /**
     * This is our "CommandEvent" method. It is called once the player enters
     * a command into chat. The provided "event" object provides access to the various
     * event information (entered command, player). 
     * Note that you have to add the annotation "@EventMethod" to all event methods,
     * otherwise they will not be recognized (and as a result, not be called when
     * the particular event gets triggered).
     * @param event our event object, which provides access to the event information
     */
    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event){
        //This string contains the full command the player has entered
        String command = event.getCommand();
        
        //Get the player who entered the command
        Player player = event.getPlayer();
        
        //Player has to enter "/ts", then he will be connected to a teamspeak server
        if(command.startsWith("/ts")){
            //There is a convenient method to connect the client to a teamspeak
            //server. You just have to provide the IP of the TeamSpeak server, the
            //port, and optionally the target channel (the player will be moved to
            //this channel automatically).
            //Note: This does only work when the client uses Windows
            
            //Replace "127.0.0.1" with your TeamSpeak IP, "1234" with the port,
            //and "Gaming/Rising World" with the target channel (in this case, 
            //"Rising World" would be a subchannel of "Gaming"). Alternatively,
            //you can just provide an empty string, then the player will be moved
            //to the default channel.
            player.connectToTeamSpeak("127.0.0.1", 1234, "Gaming/Rising World");
        }
    }

}
